/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.runtime.installer.InstallationProperties;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.UserInfo;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.util.FileResourceBundle;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

class Common {
    Common() {
    }

    public static boolean checkAdmin() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.isAdminRequired() && !UserInfo.isAdminUser()) {
            GUIHelper.showMessage(null, Messages.getMessages().getString("AdminPrivilegesRequired"), 0);
            return false;
        }
        return true;
    }

    public static boolean checkRunningProcesses(InstallationProperties installationProperties, boolean bl, String string) {
        FileResourceBundle fileResourceBundle;
        String string2;
        int n;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        do {
            List list;
            if ((list = Common.getRunningProcesses(installationProperties)).size() == 0) {
                return true;
            }
            if (bl) {
                return false;
            }
            fileResourceBundle = Messages.getMessages();
            string2 = MessageFormat.format(fileResourceBundle.getString(string), InstallerConfig.getCurrentInstance().getApplicationName());
        } while ((n = GUIHelper.showOptionDialog(null, string2, new String[]{fileResourceBundle.getString("ButtonOK"), fileResourceBundle.getString("ButtonCancel")}, 2)) != 1);
        return false;
    }

    private static List getRunningProcesses(InstallationProperties installationProperties) {
        String[] stringArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        ArrayList arrayList2 = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
        Object object = installerConfig.getServices().iterator();
        while (object.hasNext()) {
            stringArray = (String[])object.next();
            arrayList2.remove(stringArray.getFile());
        }
        try {
            object = installationProperties.getCanonicalFilePropertySet("launcher");
            stringArray = Misc.getRunningUserProcesses();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]).getCanonicalFile();
                    if (!object.contains(file)) continue;
                    arrayList.add(file);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }
}

