/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.Age;
import com.sun.speech.freetts.Gender;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.diphone.DiphonePitchmarkGenerator;
import com.sun.speech.freetts.diphone.DiphoneUnitSelector;
import com.sun.speech.freetts.en.us.CMUDiphoneVoicePostLexicalAnalyzer;
import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.en.us.CMUVoice;
import com.sun.speech.freetts.relp.UnitConcatenator;
import de.dfki.lt.freetts.ConcatenativeVoice;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

public class CMUDiphoneVoice
extends CMUVoice
implements ConcatenativeVoice {
    protected URL database;

    public CMUDiphoneVoice() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public CMUDiphoneVoice(String name, Gender gender, Age age, String description, Locale locale, String domain, String organization, CMULexicon lexicon, URL database) {
        super(name, gender, age, description, locale, domain, organization, lexicon);
        this.setRate(150.0f);
        this.setPitch(100.0f);
        this.setPitchRange(11.0f);
        this.database = database;
    }

    @Override
    public URL getDatabase() {
        if (this.database == null) {
            String name = this.getFeatures().getString("databaseName");
            this.database = this.getClass().getResource(name);
        }
        return this.database;
    }

    @Override
    protected void setupFeatureSet() throws IOException {
        super.setupFeatureSet();
    }

    @Override
    protected UtteranceProcessor getPostLexicalAnalyzer() throws IOException {
        return new CMUDiphoneVoicePostLexicalAnalyzer();
    }

    @Override
    public UtteranceProcessor getPitchmarkGenerator() throws IOException {
        return new DiphonePitchmarkGenerator();
    }

    @Override
    public UtteranceProcessor getUnitConcatenator() throws IOException {
        return new UnitConcatenator();
    }

    @Override
    public UtteranceProcessor getUnitSelector() throws IOException {
        return new DiphoneUnitSelector(this.getDatabase());
    }

    @Override
    public String toString() {
        return "CMUDiphoneVoice";
    }
}

