/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.media.rtp.rtcp.Feedback;

public class RTCPFeedback
implements Feedback {
    public static final int SIZE = 24;
    private long ssrc = 0L;
    private int fractionLost = 0;
    private long numLost = 0L;
    private long xtndSeqNum = 0L;
    private long jitter = 0L;
    private long lsr = 0L;
    private long dlsr = 0L;

    public RTCPFeedback(byte[] data, int offset, int length) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data, offset, length));
        this.ssrc = (long)stream.readInt() & 0xFFFFFFFFL;
        this.fractionLost = stream.readUnsignedByte();
        this.numLost = stream.readUnsignedShort() << 8 | stream.readUnsignedByte();
        this.xtndSeqNum = (long)stream.readInt() & 0xFFFFFFFFL;
        this.jitter = (long)stream.readInt() & 0xFFFFFFFFL;
        this.lsr = (long)stream.readInt() & 0xFFFFFFFFL;
        this.dlsr = (long)stream.readInt() & 0xFFFFFFFFL;
    }

    public long getDLSR() {
        return this.dlsr;
    }

    public int getFractionLost() {
        return this.fractionLost;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLSR() {
        return this.lsr;
    }

    public long getNumLost() {
        return this.numLost;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public long getXtndSeqNum() {
        return this.xtndSeqNum;
    }
}

