/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.control.JitterBufferControl;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPStats;
import net.sf.fmj.media.rtp.SSRCInfo;

class JitterBufferStats
implements JitterBufferControl {
    private int discardedFull;
    private int discardedLate;
    private int discardedReset;
    private int discardedShrink;
    private int discardedVeryLate;
    private int maxSizeReached;
    private int nbAdd;
    private int nbGrow;
    private int nbReset;
    private int sizePerPacket;
    private final RTPSourceStream stream;

    JitterBufferStats(RTPSourceStream rTPSourceStream) {
        this.stream = rTPSourceStream;
    }

    public int getAbsoluteMaximumDelay() {
        return this.stream.getBehaviour().getAbsoluteMaximumDelay();
    }

    public Component getControlComponent() {
        return null;
    }

    public int getCurrentDelayMs() {
        return this.getCurrentDelayPackets() * 20;
    }

    public int getCurrentDelayPackets() {
        return this.getCurrentSizePackets() / 2;
    }

    public int getCurrentPacketCount() {
        return this.stream.q.getFillCount();
    }

    public int getCurrentSizePackets() {
        return this.stream.q.getCapacity();
    }

    public int getDiscarded() {
        return this.getDiscardedFull() + this.getDiscardedLate() + this.getDiscardedReset() + this.getDiscardedShrink() + this.getDiscardedVeryLate();
    }

    public int getDiscardedFull() {
        return this.discardedFull;
    }

    public int getDiscardedLate() {
        return this.discardedLate;
    }

    public int getDiscardedReset() {
        return this.discardedReset;
    }

    public int getDiscardedShrink() {
        return this.discardedShrink;
    }

    public int getDiscardedVeryLate() {
        return this.discardedVeryLate;
    }

    public int getMaximumDelay() {
        return this.stream.getBehaviour().getMaximumDelay();
    }

    public int getMaxSizeReached() {
        return this.maxSizeReached;
    }

    int getNbAdd() {
        return this.nbAdd;
    }

    public int getNominalDelay() {
        return this.stream.getBehaviour().getNominalDelay();
    }

    int getSizePerPacket() {
        return this.sizePerPacket;
    }

    void incrementDiscardedFull() {
        ++this.discardedFull;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedLate() {
        ++this.discardedLate;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedReset() {
        ++this.discardedReset;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedShrink() {
        ++this.discardedShrink;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedVeryLate() {
        ++this.discardedVeryLate;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementNbAdd() {
        ++this.nbAdd;
    }

    void incrementNbGrow() {
        ++this.nbGrow;
    }

    void incrementNbReset() {
        ++this.nbReset;
    }

    private void incrementRTPStatsPDUDrop() {
        PushBufferStream[] pushBufferStreamArray;
        DataSource dataSource = this.stream.datasource;
        if (dataSource != null && (pushBufferStreamArray = dataSource.getStreams()) != null) {
            for (PushBufferStream pushBufferStream : pushBufferStreamArray) {
                RTPStats rTPStats;
                SSRCInfo sSRCInfo;
                if (pushBufferStream != this.stream) continue;
                RTPSessionMgr rTPSessionMgr = dataSource.getMgr();
                if (rTPSessionMgr == null || (sSRCInfo = rTPSessionMgr.getSSRCInfo(dataSource.getSSRC())) == null || sSRCInfo.dsource != dataSource || sSRCInfo.dstream != this.stream || (rTPStats = sSRCInfo.stats) == null) break;
                rTPStats.update(8);
                break;
            }
        }
    }

    public boolean isAdaptiveBufferEnabled() {
        return this.stream.getBehaviour().isAdaptive();
    }

    void printStats() {
        String string = RTPSourceStream.class.getName() + " ";
        Log.info(string + "Total packets added: " + this.getNbAdd());
        Log.info(string + "Times reset() called: " + this.nbReset);
        Log.info(string + "Times grow() called: " + this.nbGrow);
        Log.info(string + "Packets dropped because full: " + this.getDiscardedFull());
        Log.info(string + "Packets dropped while shrinking: " + this.getDiscardedShrink());
        Log.info(string + "Packets dropped because they were late: " + this.getDiscardedLate());
        Log.info(string + "Packets dropped because they were late by more than MAX_SIZE: " + this.getDiscardedVeryLate());
        Log.info(string + "Packets dropped in reset(): " + this.getDiscardedReset());
        Log.info(string + "Max size reached: " + this.getMaxSizeReached());
        Log.info(string + "Adaptive jitter buffer mode was " + (this.isAdaptiveBufferEnabled() ? "enabled" : "disabled"));
    }

    void updateMaxSizeReached() {
        int n = this.getCurrentSizePackets();
        if (this.maxSizeReached < n) {
            this.maxSizeReached = n;
        }
    }

    void updateSizePerPacket(Buffer buffer) {
        int n = buffer.getLength();
        this.sizePerPacket = this.sizePerPacket == 0 ? n : (this.sizePerPacket + n) / 2;
    }
}

