/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen.nanohttpd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class NanoHTTPD {
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    private int myTcpPort;
    protected File myFileDir;
    private static Hashtable<String, String> theMimeTypes = new Hashtable();
    private static SimpleDateFormat gmtFrmt;
    private static final String LICENCE = "Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    public static void main(String[] stringArray) {
        int n;
        System.out.println("NanoHTTPD 1.02 (C) 2001,2005 Jarno Elonen\n(Command line options: [port] [--licence])\n");
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].toLowerCase().endsWith("licence")) continue;
            n2 = n;
            System.out.println("Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        n = 80;
        if (stringArray.length > 0 && n2 != 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1 && stringArray[1].toLowerCase().endsWith("licence")) {
            System.out.println("Copyright (C) 2001,2005 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        NanoHTTPD nanoHTTPD = null;
        try {
            nanoHTTPD = new NanoHTTPD(n);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't start server:\n" + iOException);
            System.exit(-1);
        }
        nanoHTTPD.myFileDir = new File("");
        System.out.println("Now serving files in port " + n + " from \"" + new File("").getAbsolutePath() + "\"");
        System.out.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NanoHTTPD(int n) throws IOException {
        this.myTcpPort = n;
        final ServerSocket serverSocket = new ServerSocket(this.myTcpPort);
        boolean bl = false;
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        try {
                            while (true) {
                                new HTTPSession(serverSocket.accept());
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
            bl = true;
        }
        finally {
            if (!bl) {
                serverSocket.close();
            }
        }
    }

    private String encodeUri(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("/")) {
                string2 = string2 + "/";
                continue;
            }
            if (string3.equals(" ")) {
                string2 = string2 + "%20";
                continue;
            }
            try {
                string2 = string2 + URLEncoder.encode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return string2;
    }

    public Response serve(String string, String string2, Properties properties, Properties properties2) {
        String string3;
        System.out.println(string2 + " '" + string + "' ");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            System.out.println("  HDR: '" + string3 + "' = '" + properties.getProperty(string3) + "'");
        }
        enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            System.out.println("  PRM: '" + string3 + "' = '" + properties2.getProperty(string3) + "'");
        }
        return this.serveFile(string, properties, new File("."), true);
    }

    public Response serveFile(String string, Properties properties, File file, boolean bl) {
        if (!file.isDirectory()) {
            return new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
        }
        if ((string = string.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
            string = string.substring(0, string.indexOf(63));
        }
        if (string.startsWith("..") || string.endsWith("..") || string.indexOf("../") >= 0) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
        }
        File file2 = new File(file, string);
        if (!file2.exists()) {
            return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
        }
        if (file2.isDirectory()) {
            if (!string.endsWith("/")) {
                string = string + "/";
                Response response = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + string + "\">" + string + "</a></body></html>");
                response.addHeader("Location", string);
                return response;
            }
            if (new File(file2, "index.html").exists()) {
                file2 = new File(file, string + "/index.html");
            } else if (new File(file2, "index.htm").exists()) {
                file2 = new File(file, string + "/index.htm");
            } else {
                if (bl) {
                    String string2;
                    int n;
                    String[] stringArray = file2.list();
                    String string3 = "<html><body><h1>Directory " + string + "</h1><br/>";
                    if (string.length() > 1 && (n = (string2 = string.substring(0, string.length() - 1)).lastIndexOf(47)) >= 0 && n < string2.length()) {
                        string3 = string3 + "<b><a href=\"" + string.substring(0, n + 1) + "\">..</a></b><br/>";
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file3 = new File(file2, stringArray[i]);
                        boolean bl2 = file3.isDirectory();
                        if (bl2) {
                            string3 = string3 + "<b>";
                            int n2 = i;
                            stringArray[n2] = stringArray[n2] + "/";
                        }
                        string3 = string3 + "<a href=\"" + this.encodeUri(string + stringArray[i]) + "\">" + stringArray[i] + "</a>";
                        if (file3.isFile()) {
                            long l = file3.length();
                            string3 = string3 + " &nbsp;<font size=2>(";
                            string3 = l < 1024L ? string3 + file3.length() + " bytes" : (l < 0x100000L ? string3 + file3.length() / 1024L + "." + file3.length() % 1024L / 10L % 100L + " KB" : string3 + file3.length() / 0x100000L + "." + file3.length() % 0x100000L / 10L % 100L + " MB");
                            string3 = string3 + ")</font>";
                        }
                        string3 = string3 + "<br/>";
                        if (!bl2) continue;
                        string3 = string3 + "</b>";
                    }
                    return new Response(HTTP_OK, MIME_HTML, string3);
                }
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
            }
        }
        String string4 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string4 = theMimeTypes.get(string.substring(n + 1).toLowerCase());
        }
        if (string4 == null) {
            string4 = MIME_DEFAULT_BINARY;
        }
        try {
            long l = 0L;
            String string5 = properties.getProperty("Range");
            if (string5 != null && string5.startsWith("bytes=")) {
                int n3 = (string5 = string5.substring("bytes=".length())).indexOf(45);
                if (n3 > 0) {
                    string5 = string5.substring(0, n3);
                }
                try {
                    l = Long.parseLong(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            fileInputStream.skip(l);
            Response response = new Response(HTTP_OK, string4, fileInputStream);
            response.addHeader("Content-length", "" + (file2.length() - l));
            response.addHeader("Content-range", "" + l + "-" + (file2.length() - 1L) + "/" + file2.length());
            return response;
        }
        catch (IOException iOException) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
        }
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer("htm\t\ttext/html html\t\ttext/html txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (stringTokenizer.hasMoreTokens()) {
            theMimeTypes.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
        }

        public Response(String string, String string2, InputStream inputStream) {
            this.status = string;
            this.mimeType = string2;
            this.data = inputStream;
        }

        public Response(String string, String string2, String string3) {
            this.status = string;
            this.mimeType = string2;
            this.data = new ByteArrayInputStream(string3.getBytes());
        }

        public void addHeader(String string, String string2) {
            this.header.put(string, string2);
        }
    }

    private class HTTPSession
    implements Runnable {
        private Socket mySocket;

        public HTTPSession(Socket socket) {
            this.mySocket = socket;
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }

        private void decodeParms(String string, Properties properties) throws InterruptedException {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n < 0) continue;
                properties.put(this.decodePercent(string2.substring(0, n)).trim(), this.decodePercent(string2.substring(n + 1)));
            }
        }

        private String decodePercent(String string) throws InterruptedException {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                block6: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '+': {
                            stringBuffer.append(' ');
                            continue block6;
                        }
                        case '%': {
                            stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block6;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
                return new String(stringBuffer.toString().getBytes());
            }
            catch (Exception exception) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        public void run() {
            try {
                Object object;
                InputStream inputStream = this.mySocket.getInputStream();
                if (inputStream == null) {
                    return;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string == null) {
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String string3 = this.decodePercent(stringTokenizer.nextToken());
                Properties properties = new Properties();
                int n = string3.indexOf(63);
                if (n >= 0) {
                    this.decodeParms(string3.substring(n + 1), properties);
                    string3 = this.decodePercent(string3.substring(0, n));
                }
                Properties properties2 = new Properties();
                if (stringTokenizer.hasMoreTokens()) {
                    object = bufferedReader.readLine();
                    while (object != null && ((String)object).trim().length() > 0) {
                        int n2 = ((String)object).indexOf(58);
                        properties2.put(((String)object).substring(0, n2).trim(), ((String)object).substring(n2 + 1).trim());
                        object = bufferedReader.readLine();
                    }
                }
                if (string2.equalsIgnoreCase("POST")) {
                    this.decodeParms(bufferedReader.readLine(), properties);
                }
                if ((object = NanoHTTPD.this.serve(string3, string2, properties2, properties)) == null) {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                } else {
                    this.sendResponse(((Response)object).status, ((Response)object).mimeType, ((Response)object).header, ((Response)object).data);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                try {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + iOException.getMessage());
                }
                catch (Throwable throwable) {}
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void sendError(String string, String string2) throws InterruptedException {
            this.sendResponse(string, NanoHTTPD.MIME_PLAINTEXT, null, new ByteArrayInputStream(string2.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String string, String string2, Properties properties, InputStream inputStream) {
            try {
                Object object;
                if (string == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                OutputStream outputStream = this.mySocket.getOutputStream();
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.print("HTTP/1.0 " + string + " \r\n");
                if (string2 != null) {
                    printWriter.print("Content-Type: " + string2 + "\r\n");
                }
                if (properties == null || properties.getProperty("Date") == null) {
                    printWriter.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (properties != null) {
                    object = properties.keys();
                    while (object.hasMoreElements()) {
                        String string3 = (String)object.nextElement();
                        String string4 = properties.getProperty(string3);
                        printWriter.print(string3 + ": " + string4 + "\r\n");
                    }
                }
                printWriter.print("\r\n");
                printWriter.flush();
                if (inputStream != null) {
                    int n;
                    object = new byte[2048];
                    while ((n = inputStream.read((byte[])object, 0, 2048)) > 0) {
                        outputStream.write((byte[])object, 0, n);
                    }
                }
                outputStream.flush();
                outputStream.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                try {
                    this.mySocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

