/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicOutPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDataOpPacket
extends _08BasicOutPacket {
    private List<String> groups;
    private byte type;

    public GroupDataOpPacket(QQUser qQUser) {
        super('<', true, qQUser);
        this.type = (byte)2;
        this.groups = new ArrayList<String>();
    }

    public GroupDataOpPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    @Override
    public String getPacketName() {
        switch (this.type) {
            case 2: {
                return "Group Data _08Packet - Upload Group";
            }
            case 1: {
                return "Group Data _08Packet - Download Group";
            }
        }
        return "Group Data _08Packet - Unknown Sub Command";
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.type);
        if (this.type == 2) {
            int n = this.groups.size();
            for (int i = 0; i < n; ++i) {
                String string = this.groups.get(i);
                byteBuffer.put((byte)(i + 1));
                byte[] byArray = Util.getBytes(string);
                if (byArray.length > 16) {
                    byteBuffer.put(byArray, 0, 16);
                    continue;
                }
                byteBuffer.put(byArray);
                int n2 = 16 - byArray.length;
                while (n2-- > 0) {
                    byteBuffer.put((byte)0);
                }
            }
        } else {
            byteBuffer.put((byte)2);
            byteBuffer.putInt(0);
        }
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> list) {
        this.groups = list;
    }
}

