/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import net.sf.jqql.net.AbstractPort;
import net.sf.jqql.net.HttpProxy;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.net.INIOHandler;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.net.PortGate;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPHttpPort
extends AbstractPort
implements IProxyHandler {
    private static final Log log = LogFactory.getLog(TCPHttpPort.class);
    private SocketChannel channel;
    private HttpProxy proxy;
    private boolean ready = false;
    private boolean remoteClosed = false;

    public TCPHttpPort(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress) throws IOException {
        super(iConnectionPolicy);
        this.remoteAddress = inetSocketAddress;
        this.proxy = new HttpProxy(this, iConnectionPolicy.getProxyUsername(), iConnectionPolicy.getProxyPassword());
        this.proxy.setProxyAddress(iConnectionPolicy.getProxy());
        this.proxy.setRemoteAddress(inetSocketAddress);
        this.channel = (SocketChannel)this.proxy.channel();
    }

    public void dispose() {
        this.proxy.dispose();
    }

    public void start() {
        this.proxy.start();
    }

    public INIOHandler getNIOHandler() {
        if (this.ready) {
            return this;
        }
        return this.proxy;
    }

    public void proxyReady(InetSocketAddress inetSocketAddress) throws IOException {
        this.ready = true;
        this.channel = (SocketChannel)this.proxy.channel();
        ((PortGate)this.getPool()).getPorter().register(this, 1);
    }

    public void proxyAuthFail() {
        this.proxyError("Proxy Auth Fail");
    }

    public void proxyError(String string) {
        ErrorPacket errorPacket = this.policy.createErrorPacket(2, this.getId());
        errorPacket.errorMessage = string;
        this.policy.pushIn(errorPacket);
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    public void receive() throws IOException, PacketParseException {
        if (this.remoteClosed) {
            return;
        }
        int n = this.receiveBuf.position();
        int n2 = this.channel.read(this.receiveBuf);
        while (n2 > 0) {
            n2 = this.channel.read(this.receiveBuf);
        }
        n2 = this.receiveBuf.position();
        this.receiveBuf.flip();
        if (n == n2) {
            ErrorPacket errorPacket = this.policy.createErrorPacket(0, this.getId());
            this.policy.pushIn(errorPacket);
            this.remoteClosed = true;
            return;
        }
        while (true) {
            _08InPacket _08InPacket2 = null;
            try {
                _08InPacket2 = this.policy.parseIn(this.receiveBuf, false);
            }
            catch (PacketParseException packetParseException) {
                this.adjustBuffer(n2);
                throw packetParseException;
            }
            if (_08InPacket2 == null && !this.policy.relocate(this.receiveBuf)) break;
            this.policy.pushIn(_08InPacket2);
        }
        this.adjustBuffer(n2);
    }

    private void adjustBuffer(int n) {
        if (this.receiveBuf.position() > 0) {
            this.receiveBuf.compact();
            this.receiveBuf.limit(this.receiveBuf.capacity());
        } else {
            this.receiveBuf.limit(this.receiveBuf.capacity());
            this.receiveBuf.position(n);
        }
    }

    public void send() throws IOException {
        while (!this.isEmpty()) {
            this.sendBuf.clear();
            _08OutPacket _08OutPacket2 = this.remove();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                _08OutPacket2.setTimeout(System.currentTimeMillis() + 5000L);
                this.policy.pushResend(_08OutPacket2, this.getId());
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                continue;
            }
            int n = _08OutPacket2.getSendCount();
            for (int i = 0; i < n; ++i) {
                this.sendBuf.rewind();
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            }
        }
    }

    public void send(_08OutPacket _08OutPacket2) {
        try {
            this.sendBuf.clear();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            } else {
                int n = _08OutPacket2.getSendCount();
                for (int i = 0; i < n; ++i) {
                    this.sendBuf.rewind();
                    this.channel.write(this.sendBuf);
                    log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage());
        }
    }

    public void send(ByteBuffer byteBuffer) {
        try {
            this.channel.write(byteBuffer);
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
        }
    }

    public boolean isConnected() {
        return this.ready;
    }

    public void processConnect(SelectionKey selectionKey) throws IOException {
    }

    public void processRead(SelectionKey selectionKey) throws IOException, PacketParseException {
        this.receive();
    }

    public void processWrite() throws IOException {
        this.send();
    }
}

