/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.ServiceType;
import org.openymsg.network.UnknowServiceException;
import org.openymsg.network.YMSG9Packet;

public class YMSG9InputStream
extends BufferedInputStream {
    private static final Log log = LogFactory.getLog(YMSG9InputStream.class);

    public YMSG9InputStream(InputStream in) {
        super(in);
    }

    public YMSG9Packet readPacket() throws IOException {
        YMSG9Packet p = new YMSG9Packet();
        String charEncoding = System.getProperty("openymsg.network.charEncoding", "UTF-8");
        byte[] header = new byte[20];
        if (this.readBuffer(header) <= 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append((char)header[i]);
        }
        p.magic = sb.toString();
        p.version = this.u2i(header[5]);
        p.length = (this.u2i(header[8]) << 8) + this.u2i(header[9]);
        p.service = ServiceType.getServiceType((this.u2i(header[10]) << 8) + this.u2i(header[11]));
        p.status = (this.u2i(header[12]) << 24) + (this.u2i(header[13]) << 16) + (this.u2i(header[14]) << 8) + this.u2i(header[15]);
        p.sessionId = (this.u2i(header[16]) << 24) + (this.u2i(header[17]) << 16) + (this.u2i(header[18]) << 8) + this.u2i(header[19]);
        if (!p.magic.equals("YMSG")) {
            throw new IOException("Bad YMSG9 header");
        }
        ArrayList<String> v = new ArrayList<String>();
        byte[] body = new byte[p.length];
        if (this.readBuffer(body) < 0) {
            return null;
        }
        int start = 0;
        boolean keyPos = true;
        for (int i = 0; i < body.length - 1; ++i) {
            if (this.u2i(body[i]) != 192 || this.u2i(body[i + 1]) != 128) continue;
            String s = new String(body, start, i - start, charEncoding);
            if (keyPos) {
                if (this.isKey(s = this.cleanse(s))) {
                    v.add(s);
                }
            } else {
                v.add(s);
            }
            keyPos = !keyPos;
            start = ++i + 1;
        }
        if (v.size() % 2 != 0) {
            v.remove(v.size() - 1);
        }
        p.body = new String[v.size()];
        p.body = v.toArray(p.body);
        log.debug((Object)p.toString());
        if (p.service == null) {
            throw new UnknowServiceException(p);
        }
        return p;
    }

    private int u2i(byte b) {
        return b & 0xFF;
    }

    private String cleanse(String s) {
        while (s.length() > 0 && (s.charAt(0) == '\u0000' || s.charAt(0) > '\u007f')) {
            s = s.substring(1);
        }
        return s;
    }

    private boolean isKey(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return s.length() <= 5;
    }

    private int readBuffer(byte[] buff) throws IOException {
        int p;
        int r = 0;
        for (p = 0; p < buff.length; p += r) {
            r = super.read(buff, p, buff.length - p);
            if (r >= 0) continue;
            return (p + 1) * -1;
        }
        return p;
    }
}

