/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml.contact;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jmyspaceiml.MSIMConnection;
import net.sf.jmyspaceiml.contact.Contact;
import net.sf.jmyspaceiml.contact.ContactListener;
import net.sf.jmyspaceiml.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactManager {
    private MSIMConnection connection;
    private List<Contact> contacts;
    private List<ContactListener> contactListeners = new CopyOnWriteArrayList<ContactListener>();

    public ContactManager(MSIMConnection connection) {
        this.connection = connection;
        this.contacts = new CopyOnWriteArrayList<Contact>();
    }

    public void requestContacts() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\\persist\\1\\sesskey\\");
        buffer.append(this.connection.getSessionKey());
        buffer.append("\\cmd\\1\\dsn\\0\\uid\\");
        buffer.append(this.connection.getUserID());
        buffer.append("\\lid\\1\\rid\\1576\\body\\\\final\\");
        Log.debug("s = " + buffer);
        this.connection.send(buffer.toString());
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void parseContactListPacket(HashMap<String, Object> rawPacket) {
        String[] toks;
        String body = (String)rawPacket.get("body");
        for (String tok : toks = body.split("ContactID")) {
            if (tok.equals("")) continue;
            Contact contact = new Contact();
            contact.parsePacketData("ContactID" + tok);
            this.contacts.add(contact);
        }
        this.invokeContactListeners();
    }

    public void addContactListener(ContactListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.contactListeners.contains(listener)) {
            this.contactListeners.add(listener);
        }
    }

    public void removeContactListener(ContactListener listener) {
        if (listener == null) {
            return;
        }
        this.contactListeners.remove(listener);
    }

    public List<ContactListener> getContactListeners() {
        return this.contactListeners;
    }

    public void invokeContactListeners() {
        for (ContactListener listener : this.contactListeners) {
            listener.contactListUpdateReceived();
        }
    }
}

