/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import socks.server.ServerAuthenticator;
import socks.server.ServerAuthenticatorNone;
import socks.server.UserValidation;

public class UserPasswordAuthenticator
extends ServerAuthenticatorNone {
    static final int METHOD_ID = 2;
    UserValidation validator;

    public UserPasswordAuthenticator(UserValidation validator) {
        this.validator = validator;
    }

    public ServerAuthenticator startSession(Socket s) throws IOException {
        InputStream in = s.getInputStream();
        OutputStream out = s.getOutputStream();
        if (in.read() != 5) {
            return null;
        }
        if (!UserPasswordAuthenticator.selectSocks5Authentication(in, out, 2)) {
            return null;
        }
        if (!this.doUserPasswordAuthentication(s, in, out)) {
            return null;
        }
        return new ServerAuthenticatorNone(in, out);
    }

    private boolean doUserPasswordAuthentication(Socket s, InputStream in, OutputStream out) throws IOException {
        int version = in.read();
        if (version != 1) {
            return false;
        }
        int ulen = in.read();
        if (ulen < 0) {
            return false;
        }
        byte[] user = new byte[ulen];
        in.read(user);
        int plen = in.read();
        if (plen < 0) {
            return false;
        }
        byte[] password = new byte[plen];
        in.read(password);
        if (!this.validator.isUserValid(new String(user), new String(password), s)) {
            out.write(new byte[]{1, 1});
            return false;
        }
        out.write(new byte[]{1, 0});
        return true;
    }
}

