/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.StringBlock;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendBuddyListGroup
implements LiveWritable {
    private final String groupName;
    private final List<String> buddies;
    private final int totalSize;

    public static List<SendBuddyListGroup> readBuddyListGroups(ByteBlock block) {
        SendBuddyListGroup group;
        DefensiveTools.checkNull((Object)block, (String)"block");
        ByteBlock nextBlock = block;
        LinkedList<SendBuddyListGroup> groups = new LinkedList<SendBuddyListGroup>();
        while ((group = SendBuddyListGroup.readBuddyListGroup(nextBlock)) != null) {
            groups.add(group);
            nextBlock = nextBlock.subBlock(group.getTotalSize());
        }
        return DefensiveTools.getUnmodifiable(groups);
    }

    @Nullable
    public static SendBuddyListGroup readBuddyListGroup(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        StringBlock groupName = SendBuddyListGroup.readString(block);
        if (groupName == null || block.getLength() < groupName.getTotalSize() + 2) {
            return null;
        }
        int buddyCount = BinaryTools.getUShort((ByteBlock)block, (int)groupName.getTotalSize());
        ArrayList<String> buddies = new ArrayList<String>(buddyCount);
        ByteBlock rest = block.subBlock(groupName.getTotalSize() + 2);
        int size = groupName.getTotalSize() + 2;
        for (int i = 0; i < buddyCount; ++i) {
            StringBlock buddyString = SendBuddyListGroup.readString(rest);
            if (buddyString == null) {
                return null;
            }
            buddies.add(buddyString.getString());
            rest = rest.subBlock(buddyString.getTotalSize());
            size += buddyString.getTotalSize();
        }
        return new SendBuddyListGroup(groupName.getString(), buddies, size);
    }

    private static StringBlock readString(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 2) {
            return null;
        }
        int len = BinaryTools.getUShort((ByteBlock)block, (int)0);
        if (block.getLength() < len + 2) {
            return null;
        }
        String str = BinaryTools.getAsciiString((ByteBlock)block.subBlock(2, len));
        return new StringBlock(str, 2 + len);
    }

    private static void writeString(OutputStream out, String str) throws IOException {
        DefensiveTools.checkNull((Object)out, (String)"out");
        DefensiveTools.checkNull((Object)str, (String)"str");
        byte[] bytes = BinaryTools.getAsciiBytes((String)str);
        BinaryTools.writeUShort((OutputStream)out, (int)bytes.length);
        out.write(bytes);
    }

    private SendBuddyListGroup(String groupName, Collection<String> buddies, int totalSize) {
        DefensiveTools.checkNull((Object)groupName, (String)"groupName");
        List safeBuddies = DefensiveTools.getSafeNonnullListCopy(buddies, (String)"buddies");
        DefensiveTools.checkRange((int)totalSize, (String)"totalSize", (int)-1);
        this.groupName = groupName;
        this.buddies = safeBuddies;
        this.totalSize = totalSize;
    }

    public SendBuddyListGroup(String groupName, Collection<String> buddies) {
        this(groupName, buddies, -1);
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final List<String> getBuddies() {
        return this.buddies;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        SendBuddyListGroup.writeString(out, this.groupName);
        BinaryTools.writeUShort((OutputStream)out, (int)this.buddies.size());
        for (String buddy : this.buddies) {
            SendBuddyListGroup.writeString(out, buddy);
        }
    }

    public String toString() {
        return "SendBuddyListGroup for group '" + this.groupName + "': " + this.buddies;
    }
}

