/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.ratelim.FutureEventQueue;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueRunner<Q extends FutureEventQueue> {
    public static final long TIMEOUT_DEFAULT = 180000L;
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.ratelim.QueueRunner");
    private final Object lock = new Object();
    private final Q queue;
    private long timeout = 180000L;
    private boolean shouldCheckQueues = true;
    private boolean shouldStop = false;
    @Nullable
    private QueueRunnerThread thread = null;

    public static <Q extends FutureEventQueue> QueueRunner<Q> create(Q queue) {
        return new QueueRunner<Q>(queue);
    }

    private QueueRunner(Q queue) {
        DefensiveTools.checkNull(queue, (String)"queue");
        this.queue = queue;
        queue.registerQueueRunner(this);
        this.update();
    }

    public Q getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            this.timeout = timeout;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.lock;
        synchronized (object) {
            this.shouldCheckQueues = true;
            this.startThreadIfNecessary();
            this.lock.notifyAll();
        }
    }

    private void startThreadIfNecessary() {
        assert (Thread.holdsLock(this.lock));
        if (this.thread != null && this.thread.running || !this.queue.hasQueues()) {
            return;
        }
        if (logger.logFineEnabled()) {
            logger.logFine("Starting queue runner due to activity");
        }
        this.startThread();
    }

    private void startThread() {
        QueueRunnerThread thread = new QueueRunnerThread();
        thread.setDaemon(true);
        thread.start();
        while (!thread.running) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopCurrentRun() {
        Object object = this.lock;
        synchronized (object) {
            if (this.thread == null || !this.thread.running) {
                return false;
            }
            this.shouldStop = true;
            this.lock.notifyAll();
            return true;
        }
    }

    protected void waitForLock(long wait) {
        assert (wait != 0L);
        try {
            this.lock.wait(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return "QueueRunner: queue=" + this.queue;
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.running;
    }

    private class QueueRunnerThread
    extends Thread {
        private volatile boolean running;

        public QueueRunnerThread() {
            super("Queue Runner");
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.setRunning(true);
                long nextDequeueTime = -1L;
                long lastActivity = System.currentTimeMillis();
                while (true) {
                    Object object = QueueRunner.this.lock;
                    synchronized (object) {
                        this.waitForUpdate(nextDequeueTime, lastActivity);
                        if (QueueRunner.this.shouldStop) {
                            if (logger.logFineEnabled()) {
                                logger.logFine("Stopping queue runner due to stopCurrentRun() call; queue is " + QueueRunner.this.queue.toString());
                            }
                            QueueRunner.this.shouldStop = false;
                            break;
                        }
                        if (nextDequeueTime == -1L) {
                            if (this.shouldStopDueToInactivity(lastActivity)) {
                                if (logger.logFineEnabled()) {
                                    logger.logFine("Stopping queue runner due to inactivity: " + (System.currentTimeMillis() - lastActivity) + "ms; queue is " + QueueRunner.this.queue.toString());
                                }
                                break;
                            }
                        } else {
                            lastActivity = System.currentTimeMillis();
                        }
                    }
                    nextDequeueTime = QueueRunner.this.queue.flushQueues();
                }
            }
            finally {
                this.setRunning(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRunning(boolean running) {
            Object object = QueueRunner.this.lock;
            synchronized (object) {
                this.running = running;
                QueueRunner.this.lock.notifyAll();
            }
        }

        private boolean shouldStopDueToInactivity(long lastActivity) {
            assert (Thread.holdsLock(QueueRunner.this.lock));
            if (lastActivity == -1L) {
                return false;
            }
            long inactiveTime = System.currentTimeMillis() - lastActivity;
            return inactiveTime > QueueRunner.this.timeout;
        }

        private void waitForUpdate(long minWait, long lastActivity) {
            assert (Thread.holdsLock(QueueRunner.this.lock));
            if (QueueRunner.this.shouldCheckQueues) {
                QueueRunner.this.shouldCheckQueues = false;
                return;
            }
            long wait = minWait == -1L ? this.computeWaitTime(lastActivity) : minWait;
            wait = Math.max(1L, Math.min(QueueRunner.this.timeout, wait));
            this.setName(this.makeStatusString(wait));
            QueueRunner.this.waitForLock(wait);
            QueueRunner.this.shouldCheckQueues = false;
        }

        private long computeWaitTime(long lastActivity) {
            assert (Thread.holdsLock(QueueRunner.this.lock));
            long sincelast = lastActivity == -1L ? 0L : System.currentTimeMillis() - lastActivity;
            return Math.max(1L, QueueRunner.this.timeout - sincelast);
        }

        private String makeStatusString(long wait) {
            assert (Thread.holdsLock(QueueRunner.this.lock));
            return "Queue Runner@" + this.hashCode() + " currentWait: " + wait + " shouldStop:" + QueueRunner.this.shouldStop + " running:" + this.running;
        }
    }
}

