/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.dcc;

import f00f.net.irc.martyr.GenericCommandAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.commands.CtcpMessage;
import f00f.net.irc.martyr.dcc.DccChatHandler;
import f00f.net.irc.martyr.dcc.DccException;
import f00f.net.irc.martyr.dcc.DccSendHandler;
import f00f.net.irc.martyr.dcc.DccType;
import f00f.net.irc.martyr.dcc.UnauthorizedDccException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AutoDccSetup
extends GenericCommandAutoService {
    static Logger log = Logger.getLogger(AutoDccSetup.class);

    public AutoDccSetup(IRCConnection connection) {
        super(connection);
        this.enable();
    }

    public void updateCommand(InCommand updated) {
        if (updated instanceof CtcpMessage) {
            try {
                this.handleCtcp((CtcpMessage)updated);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (DccException dcce) {
                dcce.printStackTrace();
            }
        }
    }

    private List tokenizeParams(String msg) {
        ArrayList<String> l = new ArrayList<String>(5);
        StringBuffer word = new StringBuffer();
        boolean inQuote = false;
        for (int i = 0; i < msg.length(); ++i) {
            char c = msg.charAt(i);
            if (c == '\"') {
                if (!inQuote) {
                    inQuote = true;
                    if (word.length() <= 0) continue;
                    l.add(word.toString());
                    word = new StringBuffer();
                    continue;
                }
                inQuote = false;
                l.add(word.toString());
                word = new StringBuffer();
                continue;
            }
            if (c == ' ' && !inQuote) {
                if (word.length() <= 0) continue;
                l.add(word.toString());
                word = new StringBuffer();
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            l.add(word.toString());
        }
        return l;
    }

    protected void handleCtcp(CtcpMessage ctcpMsg) throws DccException, IOException {
        if (!ctcpMsg.getAction().toLowerCase().equals("dcc")) {
            return;
        }
        log.debug((Object)("AutoDccSetup: " + ctcpMsg.getMessage()));
        Iterator tokens = this.tokenizeParams(ctcpMsg.getMessage()).iterator();
        String typeStr = (String)tokens.next();
        String argument = (String)tokens.next();
        String addressStr = (String)tokens.next();
        String portStr = (String)tokens.next();
        String fileSizeStr = tokens.hasNext() ? (String)tokens.next() : null;
        InetAddress netaddr = InetAddress.getByName(addressStr);
        int port = Integer.parseInt(portStr);
        int fileSize = fileSizeStr == null ? -1 : Integer.parseInt(fileSizeStr);
        DccType type = DccType.getInstance(typeStr);
        if (!this.authorizeConnect(type, argument, netaddr, port, fileSize)) {
            throw new UnauthorizedDccException("Denied.");
        }
        Socket socket = this.makeSocket(netaddr, port);
        this.handleDccConnection(socket, type, argument, fileSize);
    }

    protected DccChatHandler getDccChatHandler(Socket socket) {
        return new DccChatHandler(socket);
    }

    protected DccSendHandler getDccSendHandler(Socket socket, String filename, int filesize) {
        return new DccSendHandler(socket, filename, filesize);
    }

    protected void handleDccConnection(Socket socket, DccType type, String filename, int filesize) {
        if (type == DccType.SEND) {
            this.getDccSendHandler(socket, filename, filesize).start();
        } else {
            this.getDccChatHandler(socket).start();
        }
    }

    protected Socket makeSocket(InetAddress dest, int port) throws IOException {
        return new Socket(dest, port);
    }

    protected abstract boolean authorizeConnect(DccType var1, String var2, InetAddress var3, int var4, int var5);

    public String toString() {
        return "AutoDccSetup";
    }
}

