/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.commands.NoticeCommand;
import f00f.net.irc.martyr.util.FullNick;
import java.util.StringTokenizer;

public class CtcpNotice
extends NoticeCommand {
    private String actionStr;

    public CtcpNotice(String dest, String message) {
        super(dest, "\u0001" + message + "\u0001");
    }

    public CtcpNotice(String dest, String action, String message) {
        this(dest, action + " " + message);
        this.actionStr = action;
    }

    protected CtcpNotice(FullNick from, String dest, String message) {
        super(from, dest, CtcpNotice.getMessageStr(CtcpNotice.stripCtcpWrapper(message)));
        this.actionStr = CtcpNotice.getActionStr(CtcpNotice.stripCtcpWrapper(message));
    }

    public String getAction() {
        return this.actionStr;
    }

    public static String getActionStr(String msg) {
        StringTokenizer tokens = new StringTokenizer(msg);
        return tokens.nextToken();
    }

    public static String getMessageStr(String msg) {
        String acn = CtcpNotice.getActionStr(msg);
        return msg.substring(acn.length()).trim();
    }

    public static boolean isCtcpString(String msg) {
        return msg.charAt(0) == '\u0001' && msg.charAt(msg.length() - 1) == '\u0001';
    }

    public static String stripCtcpWrapper(String msg) {
        if (CtcpNotice.isCtcpString(msg)) {
            return msg.substring(1, msg.length() - 1);
        }
        return msg;
    }
}

