/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.PersonalInfo;
import pl.mn.communicator.PublicDirSearchReply;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.handlers.PacketContext;
import pl.mn.communicator.packet.handlers.PacketHandler;
import pl.mn.communicator.packet.in.GGPubdirReply;

public class GGPubdirReplyPacketHandler
implements PacketHandler {
    private static final Log logger = LogFactory.getLog((Class)GGPubdirReplyPacketHandler.class);

    public void handle(PacketContext context) throws GGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received GGPubdirReply packet.");
            logger.debug((Object)("PacketHeader: " + context.getHeader()));
            logger.debug((Object)("PacketBody: " + GGUtils.prettyBytesToString(context.getPackageContent())));
        }
        GGPubdirReply pubdirReply = new GGPubdirReply(context.getPackageContent());
        int querySeq = pubdirReply.getQuerySeq();
        if (pubdirReply.isPubdirReadReply()) {
            PersonalInfo publicDirInfo = pubdirReply.getPubdirReadReply();
            context.getSessionAccessor().notifyPubdirRead(querySeq, publicDirInfo);
        } else if (pubdirReply.isPubdirWriteReply()) {
            context.getSessionAccessor().notifyPubdirUpdated(querySeq);
        } else if (pubdirReply.isPubdirSearchReply()) {
            PublicDirSearchReply pubDirSearchReply = pubdirReply.getPubdirSearchReply();
            context.getSessionAccessor().notifyPubdirGotSearchResults(querySeq, pubDirSearchReply);
        }
    }
}

