/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.IContactListService;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.event.ContactListListener;
import pl.mn.communicator.packet.out.GGUserListRequest;

public class DefaultContactListService
implements IContactListService {
    private HashSet m_contactListListeners = null;
    private Session m_session = null;

    DefaultContactListService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
        this.m_contactListListeners = new HashSet();
    }

    public void clearContactList() throws GGException {
        this.checkSessionState();
        try {
            GGUserListRequest clearContactListRequest = GGUserListRequest.createClearUsetListRequest();
            this.m_session.getSessionAccessor().sendPackage(clearContactListRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to clear contact list", ex);
        }
    }

    public void exportContactList(Collection localUsers) throws GGException {
        this.checkSessionState();
        try {
            GGUserListRequest putUserListRequest = GGUserListRequest.createPutUserListRequest(localUsers);
            this.m_session.getSessionAccessor().sendPackage(putUserListRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to export contact list", ex);
        }
    }

    public void importContactList() throws GGException {
        this.checkSessionState();
        try {
            GGUserListRequest getContactListRequest = GGUserListRequest.createGetUserListRequest();
            this.m_session.getSessionAccessor().sendPackage(getContactListRequest);
        }
        catch (IOException ex) {
            throw new GGException("Unable to import contact list", ex);
        }
    }

    private void checkSessionState() throws GGSessionException {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
    }

    public void addContactListListener(ContactListListener contactListListener) {
        if (contactListListener == null) {
            throw new NullPointerException("contactListListener cannot be null");
        }
        this.m_contactListListeners.add(contactListListener);
    }

    public void removeContactListlistener(ContactListListener contactListListener) {
        if (contactListListener == null) {
            throw new NullPointerException("conractListListener cannot be null");
        }
        this.m_contactListListeners.add(contactListListener);
    }

    protected void notifyContactListExported() {
        Iterator it = this.m_contactListListeners.iterator();
        while (it.hasNext()) {
            ContactListListener contactListListener = (ContactListListener)it.next();
            contactListListener.contactListExported();
        }
    }

    protected void notifyContactListReceived(Collection users) {
        Iterator it = this.m_contactListListeners.iterator();
        while (it.hasNext()) {
            ContactListListener contactListListener = (ContactListListener)it.next();
            contactListListener.contactListReceived(users);
        }
    }
}

