/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.outgoing;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.protocol.MsnOutgoingMessage;

public class OutgoingADL
extends MsnOutgoingMessage {
    private MsnContactImpl contact = null;

    public OutgoingADL(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("ADL");
    }

    protected boolean isSupportChunkData() {
        return true;
    }

    public void setContact(MsnContactImpl msnContactImpl) {
        this.contact = msnContactImpl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ml l=\"1\">");
        String string = msnContactImpl.getEmail().getEmailAddress();
        stringBuilder.append("<d n=\"" + OutgoingADL.getDomain(string) + "\">");
        int n = msnContactImpl.getListNumber();
        if (msnContactImpl.isInList(MsnList.PL)) {
            n -= MsnList.PL.getListId();
        }
        if (msnContactImpl.isInList(MsnList.RL)) {
            n -= MsnList.RL.getListId();
        }
        stringBuilder.append("<c n=\"" + OutgoingADL.getName(msnContactImpl.getEmail().getEmailAddress()) + "\" l=\"" + n + "\" t=\"1\" />");
        stringBuilder.append("</d>");
        stringBuilder.append("</ml>");
        this.setChunkData(stringBuilder.toString());
    }

    public void addContacts(MsnContact[] msnContactArray) {
        Vector<Object> vector;
        Hashtable<String, Vector<Object>> hashtable = new Hashtable<String, Vector<Object>>();
        for (int i = 0; i < msnContactArray.length; ++i) {
            MsnContact msnContact = msnContactArray[i];
            String object = OutgoingADL.getDomain(msnContact.getEmail().getEmailAddress());
            vector = (Vector<Object>)hashtable.get(object);
            if (vector == null) {
                vector = new Vector<Object>();
                hashtable.put(object, vector);
            }
            vector.add(msnContact);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ml l=\"1\">");
        for (Map.Entry entry : hashtable.entrySet()) {
            vector = (String)entry.getKey();
            stringBuilder.append("<d n=\"" + (String)((Object)vector) + "\">");
            Vector vector2 = (Vector)entry.getValue();
            for (MsnContactImpl msnContactImpl : vector2) {
                int n = msnContactImpl.getListNumber();
                if (msnContactImpl.isInList(MsnList.PL)) {
                    n -= MsnList.PL.getListId();
                }
                if (msnContactImpl.isInList(MsnList.RL)) {
                    n -= MsnList.RL.getListId();
                }
                stringBuilder.append("<c n=\"" + OutgoingADL.getName(msnContactImpl.getEmail().getEmailAddress()) + "\" l=\"" + n + "\" t=\"1\" />");
            }
            stringBuilder.append("</d>");
        }
        stringBuilder.append("</ml>");
        this.setChunkData(stringBuilder.toString());
    }

    private static String getDomain(String string) {
        return string.substring(string.indexOf("@") + 1);
    }

    private static String getName(String string) {
        return string.substring(0, string.indexOf("@"));
    }

    public MsnContactImpl getContact() {
        return this.contact;
    }
}

