/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.Date;
import java.util.Vector;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserPropertyType;
import net.sf.jml.impl.BasicMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.outgoing.OutgoingADC;
import net.sf.jml.protocol.outgoing.OutgoingADD;
import net.sf.jml.protocol.outgoing.OutgoingADG;
import net.sf.jml.protocol.outgoing.OutgoingREA;
import net.sf.jml.protocol.outgoing.OutgoingREG;
import net.sf.jml.protocol.outgoing.OutgoingREM;
import net.sf.jml.protocol.outgoing.OutgoingRMG;
import net.sf.jml.protocol.outgoing.OutgoingSBP;
import net.sf.jml.protocol.outgoing.OutgoingXFR;
import net.sf.jml.util.StringUtils;

public class SimpleMessenger
extends BasicMessenger {
    private RateThread rater = new RateThread();
    private Thread rateThread = null;

    SimpleMessenger(Email email, String string) {
        super(email, string);
    }

    public void newSwitchboard(Object object) {
        OutgoingXFR outgoingXFR = new OutgoingXFR(this.getActualMsnProtocol());
        outgoingXFR.setAttachment(object);
        this.rater.sendMessage(outgoingXFR);
    }

    public void logout() {
        if (this.rater != null) {
            this.rater.stopCurrentRun();
        }
        super.logout();
    }

    public void login(String string, int n) {
        this.rateThread = new Thread(this.rater);
        this.rateThread.setDaemon(true);
        this.rateThread.start();
        super.login(string, n);
    }

    public void addGroup(String string) {
        if (string == null) {
            return;
        }
        if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            OutgoingADG outgoingADG = new OutgoingADG(this.getActualMsnProtocol());
            outgoingADG.setGroupName(string);
            this.send(outgoingADG);
        } else {
            this.session.getContactList().createGroup(string);
        }
    }

    public void removeGroup(String string) {
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null) {
            if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
                OutgoingRMG outgoingRMG = new OutgoingRMG(this.getActualMsnProtocol());
                outgoingRMG.setGroupId(string);
                this.send(outgoingRMG);
            } else {
                this.session.getContactList().removeGroup(string);
            }
        }
    }

    public void renameGroup(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null && !msnGroup.isDefaultGroup() && !msnGroup.getGroupName().equals(string2)) {
            if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
                OutgoingREG outgoingREG = new OutgoingREG(this.getActualMsnProtocol());
                outgoingREG.setGroupId(string);
                outgoingREG.setGroupName(string2);
                this.send(outgoingREG);
            } else {
                this.session.getContactList().renameGroup(string, string2);
            }
        }
    }

    public void addFriend(MsnList msnList, Email email, String string) {
        if (msnList == null || email == null || msnList == MsnList.RL || msnList == MsnList.PL) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null && msnContact.isInList(msnList)) {
            return;
        }
        MsnProtocol msnProtocol = this.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP9) && msnProtocol.before(MsnProtocol.MSNP13)) {
            OutgoingADC outgoingADC = new OutgoingADC(msnProtocol);
            outgoingADC.setAddtoList(msnList);
            outgoingADC.setEmail(email);
            if (msnList == MsnList.FL) {
                outgoingADC.setFriendlyName(string == null ? email.getEmailAddress() : string);
            }
            this.send(outgoingADC);
        } else if (msnProtocol.after(MsnProtocol.MSNP13)) {
            this.session.getContactList().addFriend(email, string);
        } else {
            OutgoingADD outgoingADD = new OutgoingADD(msnProtocol);
            outgoingADD.setAddtoList(msnList);
            outgoingADD.setEmail(email);
            outgoingADD.setFriendlyName(string == null ? email.getEmailAddress() : string);
            this.send(outgoingADD);
        }
    }

    private void removeFriend(MsnList msnList, Email email, String string, String string2) {
        if (msnList == null || msnList == MsnList.RL) {
            return;
        }
        if (msnList == MsnList.FL ? string == null : email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact == null || !msnContact.isInList(msnList)) {
            return;
        }
        if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            OutgoingREM outgoingREM = new OutgoingREM(this.getActualMsnProtocol());
            outgoingREM.setRemoveFromList(msnList);
            if (msnList == MsnList.FL) {
                outgoingREM.setId(string);
                if (string2 != null) {
                    outgoingREM.setGroupId(string2);
                }
            } else {
                outgoingREM.setEmail(email);
            }
            this.send(outgoingREM);
        } else {
            this.session.getContactList().removeFriend(msnList, email, string, string2);
        }
    }

    public void addFriend(Email email, String string) {
        if (email == null) {
            return;
        }
        if (string == null) {
            string = email.getEmailAddress();
        }
        if (!this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            this.session.getContactList().addFriend(email, string);
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            if (!msnContact.isInList(MsnList.FL)) {
                if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
                    this.addFriend(MsnList.FL, email, string);
                } else {
                    this.session.getContactList().addFriendToList(new MsnList[]{MsnList.FL}, (MsnContactImpl)msnContact);
                }
            }
            if (!msnContact.isInList(MsnList.AL)) {
                if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
                    this.addFriend(MsnList.AL, email, string);
                } else {
                    this.session.getContactList().addFriendToList(new MsnList[]{MsnList.AL}, (MsnContactImpl)msnContact);
                }
            }
        } else if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            this.addFriend(MsnList.FL, email, string);
            this.addFriend(MsnList.AL, email, string);
        } else {
            this.session.getContactList().addFriend(email, string);
        }
    }

    public void blockFriend(Email email) {
        if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            this.removeFriend(MsnList.AL, email, null, null);
            this.addFriend(MsnList.BL, email, null);
        } else {
            this.session.getContactList().blockFriend(email);
        }
    }

    public void copyFriend(Email email, String string) {
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnContact == null || msnGroup == null || msnGroup.isDefaultGroup()) {
            return;
        }
        MsnProtocol msnProtocol = this.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP9) && msnProtocol.before(MsnProtocol.MSNP13)) {
            OutgoingADC outgoingADC = new OutgoingADC(msnProtocol);
            outgoingADC.setAddtoList(MsnList.FL);
            outgoingADC.setId(msnContact.getId());
            outgoingADC.setGroupId(string);
            this.send(outgoingADC);
        } else if (msnProtocol.before(MsnProtocol.MSNP9)) {
            OutgoingADD outgoingADD = new OutgoingADD(msnProtocol);
            outgoingADD.setAddtoList(MsnList.FL);
            outgoingADD.setEmail(email);
            outgoingADD.setFriendlyName(msnContact.getFriendlyName());
            outgoingADD.setGroupId(string);
            this.send(outgoingADD);
        } else {
            this.session.getContactList().copyFriend(email, string);
        }
    }

    public void moveFriend(Email email, String string, String string2) {
        if (email == null) {
            return;
        }
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        MsnGroup msnGroup2 = this.getContactList().getGroup(string2);
        if (msnGroup == null || msnGroup2 == null || msnGroup.equals(msnGroup2)) {
            return;
        }
        if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            if (msnGroup2.isDefaultGroup()) {
                this.removeFriend(email, string);
            } else {
                this.copyFriend(email, string2);
                if (!msnGroup.isDefaultGroup()) {
                    this.removeFriend(email, string);
                }
            }
        } else {
            this.session.getContactList().moveFriend(email, string, string2);
        }
    }

    public void removeFriend(Email email, boolean bl) {
        if (email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            this.removeFriend(MsnList.FL, email, msnContact.getId(), null);
            if (bl) {
                this.blockFriend(email);
            }
        }
    }

    public void removeFriend(Email email, String string) {
        if (email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            this.removeFriend(MsnList.FL, email, msnContact.getId(), string);
        }
    }

    public void removeFriend(MsnList msnList, Email email) {
        if (msnList == null || email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            this.removeFriend(msnList, email, msnContact.getId(), null);
        }
    }

    public void renameFriend(Email email, String string) {
        if (email == null || string == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            MsnProtocol msnProtocol = this.getActualMsnProtocol();
            if (msnProtocol.after(MsnProtocol.MSNP10) && msnProtocol.before(MsnProtocol.MSNP13)) {
                OutgoingSBP outgoingSBP = new OutgoingSBP(this.getActualMsnProtocol());
                outgoingSBP.setId(msnContact.getId());
                outgoingSBP.setPropertyType(MsnUserPropertyType.MFN);
                outgoingSBP.setProperty(StringUtils.urlEncode(string));
                this.send(outgoingSBP);
            } else if (msnProtocol.after(MsnProtocol.MSNP13)) {
                this.session.getContactList().updateFriend(email, msnContact.getId(), string);
            } else {
                OutgoingREA outgoingREA = new OutgoingREA(this.getActualMsnProtocol());
                outgoingREA.setId(msnContact.getEmail().getEmailAddress());
                outgoingREA.setFriendlyName(StringUtils.urlEncode(string));
                this.send(outgoingREA);
            }
        }
    }

    public void unblockFriend(Email email) {
        if (this.getActualMsnProtocol().before(MsnProtocol.MSNP13)) {
            this.removeFriend(MsnList.BL, email, null, null);
            this.addFriend(MsnList.AL, email, null);
        } else {
            this.session.getContactList().unblockFriend(email);
        }
    }

    public class RateThread
    implements Runnable {
        private Vector waitingMessages = new Vector();
        private int NUMBER_MESSAGES = 8;
        private long MAX_SECONDS = 55L;
        Vector times = new Vector(this.NUMBER_MESSAGES - 1);
        private boolean shouldStop = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.shouldStop = false;
            while (true) {
                Vector vector = this.waitingMessages;
                synchronized (vector) {
                    try {
                        if (this.waitingMessages.isEmpty()) {
                            this.waitingMessages.wait();
                        }
                        if (this.shouldStop) {
                            return;
                        }
                        if (this.waitingMessages.size() > 0) {
                            this.sendIt(this.waitingMessages.remove(0));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopCurrentRun() {
            Vector vector = this.waitingMessages;
            synchronized (vector) {
                this.shouldStop = true;
                this.waitingMessages.notifyAll();
            }
        }

        private void sendIt(Object object) {
            Date date = new Date();
            if (this.times.size() == this.NUMBER_MESSAGES - 1) {
                Date date2 = (Date)this.times.get(0);
                long l = date.getTime() - date2.getTime();
                if (l < this.MAX_SECONDS * 1000L) {
                    this.waitFor(this.MAX_SECONDS * 1000L - l);
                    date = new Date();
                }
                this.times.remove(0);
            }
            SimpleMessenger.this.send((MsnOutgoingMessage)object);
            this.times.add(date);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(MsnOutgoingMessage msnOutgoingMessage) {
            Vector vector = this.waitingMessages;
            synchronized (vector) {
                this.waitingMessages.add(msnOutgoingMessage);
                this.waitingMessages.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor(long l) {
            Object object;
            Object object2 = object = new Object();
            synchronized (object2) {
                try {
                    object.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

