/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.GenericObject;
import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.Token;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelURLImpl;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;

public class URLParser
extends Parser {
    public URLParser(String string) {
        this.lexer = new Lexer("sip_urlLexer", string);
    }

    public URLParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("sip_urlLexer");
    }

    protected static boolean isMark(char c) {
        switch (c) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isUnreserved(char c) {
        return Lexer.isAlphaDigit(c) || URLParser.isMark(c);
    }

    protected static boolean isReservedNoSlash(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case ':': 
            case ';': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isUserUnreserved(char c) {
        switch (c) {
            case '#': 
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ';': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    protected String unreserved() throws ParseException {
        char c = this.lexer.lookAhead(0);
        if (URLParser.isUnreserved(c)) {
            this.lexer.consume(1);
            return String.valueOf(c);
        }
        throw this.createParseException("unreserved");
    }

    protected String paramNameOrValue() throws ParseException {
        int n = this.lexer.getPtr();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            boolean bl = false;
            switch (c) {
                case '$': 
                case '&': 
                case '+': 
                case '/': 
                case ':': 
                case '[': 
                case ']': {
                    bl = true;
                }
            }
            if (bl || URLParser.isUnreserved(c)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        return this.lexer.getBuffer().substring(n, this.lexer.getPtr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameValue uriParam() throws ParseException {
        boolean bl;
        String string;
        String string2;
        block4: {
            string2 = "";
            string = this.paramNameOrValue();
            char c = this.lexer.lookAhead(0);
            bl = true;
            if (c == '=') {
                this.lexer.consume(1);
                string2 = this.paramNameOrValue();
                bl = false;
            }
            if (string.length() != 0 || string2 != null && string2.length() != 0) break block4;
            NameValue nameValue = null;
            return nameValue;
        }
        NameValue nameValue = new NameValue(string, string2, bl);
        return nameValue;
    }

    protected static boolean isReserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    protected String reserved() throws ParseException {
        char c = this.lexer.lookAhead(0);
        if (URLParser.isReserved(c)) {
            this.lexer.consume(1);
            return "" + c;
        }
        throw this.createParseException("reserved");
    }

    protected boolean isEscaped() {
        try {
            return this.lexer.lookAhead(0) == '%' && Lexer.isHexDigit(this.lexer.lookAhead(1)) && Lexer.isHexDigit(this.lexer.lookAhead(2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String escaped() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.lexer.lookAhead(0);
        char c2 = this.lexer.lookAhead(1);
        char c3 = this.lexer.lookAhead(2);
        if (c != '%' || !Lexer.isHexDigit(c2) || !Lexer.isHexDigit(c3)) {
            throw this.createParseException("escaped");
        }
        this.lexer.consume(3);
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        String string = stringBuffer.toString();
        return string;
    }

    protected String mark() throws ParseException {
        block3: {
            char c = this.lexer.lookAhead(0);
            if (!URLParser.isMark(c)) break block3;
            this.lexer.consume(1);
            String string = new String(new char[]{c});
            return string;
        }
        throw this.createParseException("mark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uric() {
        block9: {
            block8: {
                char c;
                block7: {
                    c = this.lexer.lookAhead(0);
                    if (!URLParser.isUnreserved(c)) break block7;
                    this.lexer.consume(1);
                    String string = Lexer.charAsString(c);
                    return string;
                }
                if (!URLParser.isReserved(c)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(c);
                return string;
            }
            if (!this.isEscaped()) break block9;
            String string = this.lexer.charAsString(3);
            this.lexer.consume(3);
            String string2 = string;
            return string2;
        }
        try {
            String string = null;
            return string;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uricNoSlash() {
        block9: {
            char c;
            block8: {
                block7: {
                    c = this.lexer.lookAhead(0);
                    if (!this.isEscaped()) break block7;
                    String string = this.lexer.charAsString(3);
                    this.lexer.consume(3);
                    String string2 = string;
                    return string2;
                }
                if (!URLParser.isUnreserved(c)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(c);
                return string;
            }
            if (!URLParser.isReservedNoSlash(c)) break block9;
            this.lexer.consume(1);
            String string = Lexer.charAsString(c);
            return string;
        }
        try {
            String string = null;
            return string;
        }
        catch (ParseException parseException) {
            String string = null;
            return string;
        }
    }

    protected String uricString() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            if ((string = this.uric()) == null) {
                char c = this.lexer.lookAhead(0);
                if (c != '[') break;
                HostNameParser hostNameParser = new HostNameParser(this.getLexer());
                HostPort hostPort = hostNameParser.hostPort(false);
                stringBuffer.append(hostPort.toString());
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericURI uriReference() throws ParseException {
        GenericURI genericURI;
        block8: {
            genericURI = null;
            Token[] tokenArray = this.lexer.peekNextToken(2);
            Token token = tokenArray[0];
            Token token2 = tokenArray[1];
            if (token.getTokenType() == 2051 || token.getTokenType() == 2136) {
                if (token2.getTokenType() == 58) {
                    genericURI = this.sipURL();
                    break block8;
                }
                throw this.createParseException("Expecting ':'");
            }
            if (token.getTokenType() == 2105) {
                if (token2.getTokenType() == 58) {
                    genericURI = this.telURL();
                    break block8;
                }
                throw this.createParseException("Expecting ':'");
            }
            String string = this.uricString();
            try {
                genericURI = new GenericURI(string);
            }
            catch (ParseException parseException) {
                throw this.createParseException(parseException.getMessage());
            }
        }
        return genericURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String base_phone_number() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (Lexer.isDigit(c) || c == '-' || c == '.' || c == '(' || c == ')') {
                this.lexer.consume(1);
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (n > 0) break;
            throw this.createParseException("unexpected " + c);
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String local_number() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (c == '*' || c == '#' || c == '-' || c == '.' || c == '(' || c == ')' || Lexer.isHexDigit(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (n > 0) break;
            throw this.createParseException("unexepcted " + c);
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TelephoneNumber parseTelephoneNumber() throws ParseException {
        TelephoneNumber telephoneNumber;
        this.lexer.selectLexer("charLexer");
        char c = this.lexer.lookAhead(0);
        if (c == '+') {
            telephoneNumber = this.global_phone_number();
        } else if (Lexer.isHexDigit(c) || c == '#' || c == '*' || c == '-' || c == '.' || c == '(' || c == ')') {
            telephoneNumber = this.local_phone_number();
        } else {
            throw this.createParseException("unexpected char " + c);
        }
        TelephoneNumber telephoneNumber2 = telephoneNumber;
        return telephoneNumber2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TelephoneNumber global_phone_number() throws ParseException {
        char c;
        TelephoneNumber telephoneNumber = new TelephoneNumber();
        telephoneNumber.setGlobal(true);
        NameValueList nameValueList = null;
        this.lexer.match(43);
        String string = this.base_phone_number();
        telephoneNumber.setPhoneNumber(string);
        if (this.lexer.hasMoreChars() && (c = this.lexer.lookAhead(0)) == ';') {
            this.lexer.consume(1);
            nameValueList = this.tel_parameters();
            telephoneNumber.setParameters(nameValueList);
        }
        TelephoneNumber telephoneNumber2 = telephoneNumber;
        return telephoneNumber2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TelephoneNumber local_phone_number() throws ParseException {
        TelephoneNumber telephoneNumber = new TelephoneNumber();
        telephoneNumber.setGlobal(false);
        NameValueList nameValueList = null;
        String string = null;
        string = this.local_number();
        telephoneNumber.setPhoneNumber(string);
        if (this.lexer.hasMoreChars()) {
            Token token = this.lexer.peekNextToken();
            switch (token.getTokenType()) {
                case 59: {
                    this.lexer.consume(1);
                    nameValueList = this.tel_parameters();
                    telephoneNumber.setParameters(nameValueList);
                    break;
                }
            }
        }
        return telephoneNumber;
    }

    private NameValueList tel_parameters() throws ParseException {
        NameValueList nameValueList = new NameValueList();
        while (true) {
            NameValue nameValue;
            String string;
            if ((string = this.paramNameOrValue()).equalsIgnoreCase("phone-context")) {
                nameValue = this.phone_context();
            } else if (this.lexer.lookAhead(0) == '=') {
                this.lexer.consume(1);
                String string2 = this.paramNameOrValue();
                nameValue = new NameValue(string, string2, false);
            } else {
                nameValue = new NameValue(string, "", true);
            }
            nameValueList.set(nameValue);
            if (this.lexer.lookAhead(0) != ';') break;
            this.lexer.consume(1);
        }
        return nameValueList;
    }

    private NameValue phone_context() throws ParseException {
        String string;
        this.lexer.match(61);
        char c = this.lexer.lookAhead(0);
        if (c == '+') {
            this.lexer.consume(1);
            string = "+" + this.base_phone_number();
        } else if (Lexer.isAlphaDigit(c)) {
            Token token = this.lexer.match(4095);
            string = token.getTokenValue();
        } else {
            throw new ParseException("Invalid phone-context:" + c, -1);
        }
        return new NameValue("phone-context", string, false);
    }

    public TelURLImpl telURL() throws ParseException {
        this.lexer.match(2105);
        this.lexer.match(58);
        TelephoneNumber telephoneNumber = this.parseTelephoneNumber();
        TelURLImpl telURLImpl = new TelURLImpl();
        telURLImpl.setTelephoneNumber(telephoneNumber);
        return telURLImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipUri sipURL() throws ParseException {
        GenericObject genericObject;
        SipUri sipUri = new SipUri();
        Token token = this.lexer.peekNextToken();
        int n = 2051;
        String string = "sip";
        if (token.getTokenType() == 2136) {
            n = 2136;
            string = "sips";
        }
        this.lexer.match(n);
        this.lexer.match(58);
        sipUri.setScheme(string);
        int n2 = this.lexer.markInputPosition();
        String string2 = this.user();
        String string3 = null;
        if (this.lexer.lookAhead() == ':') {
            this.lexer.consume(1);
            string3 = this.password();
        }
        if (this.lexer.lookAhead() == '@') {
            this.lexer.consume(1);
            sipUri.setUser(string2);
            if (string3 != null) {
                sipUri.setUserPassword(string3);
            }
        } else {
            this.lexer.rewindInputPosition(n2);
        }
        HostNameParser hostNameParser = new HostNameParser(this.getLexer());
        HostPort hostPort = hostNameParser.hostPort(false);
        sipUri.setHostPort(hostPort);
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ';') {
            this.lexer.consume(1);
            genericObject = this.uriParam();
            if (genericObject == null) continue;
            sipUri.setUriParameter((NameValue)genericObject);
        }
        if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '?') {
            this.lexer.consume(1);
            while (this.lexer.hasMoreChars()) {
                genericObject = this.qheader();
                sipUri.setQHeader((NameValue)genericObject);
                if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) != '&') break;
                this.lexer.consume(1);
            }
        }
        genericObject = sipUri;
        return genericObject;
    }

    public String peekScheme() throws ParseException {
        Token[] tokenArray = this.lexer.peekNextToken(1);
        if (tokenArray.length == 0) {
            return null;
        }
        String string = tokenArray[0].getTokenValue();
        return string;
    }

    protected NameValue qheader() throws ParseException {
        String string = this.lexer.getNextToken('=');
        this.lexer.consume(1);
        String string2 = this.hvalue();
        return new NameValue(string, string2, false);
    }

    protected String hvalue() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            boolean bl = false;
            switch (c) {
                case '!': 
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    bl = true;
                }
            }
            if (bl || Lexer.isAlphaDigit(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                continue;
            }
            if (c != '%') break;
            stringBuffer.append(this.escaped());
        }
        return stringBuffer.toString();
    }

    protected String urlString() throws ParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && (c = this.lexer.lookAhead(0)) != ' ' && c != '\t' && c != '\n' && c != '>' && c != '<') {
            this.lexer.consume(0);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String user() throws ParseException {
        int n = this.lexer.getPtr();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (URLParser.isUnreserved(c) || URLParser.isUserUnreserved(c)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        String string = this.lexer.getBuffer().substring(n, this.lexer.getPtr());
        return string;
    }

    protected String password() throws ParseException {
        int n = this.lexer.getPtr();
        while (true) {
            char c = this.lexer.lookAhead(0);
            boolean bl = false;
            switch (c) {
                case '$': 
                case '&': 
                case '+': 
                case ',': 
                case '=': {
                    bl = true;
                }
            }
            if (bl || URLParser.isUnreserved(c)) {
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            this.lexer.consume(3);
        }
        return this.lexer.getBuffer().substring(n, this.lexer.getPtr());
    }

    public GenericURI parse() throws ParseException {
        return this.uriReference();
    }

    public static void main(String[] stringArray) throws ParseException {
        String[] stringArray2 = new String[]{"sip:alice@example.com", "sips:alice@examples.com", "sip:3Zqkv5dajqaaas0tCjCxT0xH2ZEuEMsFl0xoasip%3A%2B3519116786244%40siplab.domain.com@213.0.115.163:7070"};
        for (int i = 0; i < stringArray2.length; ++i) {
            URLParser uRLParser = new URLParser(stringArray2[i]);
            GenericURI genericURI = uRLParser.parse();
            System.out.println("uri type returned " + genericURI.getClass().getName());
            System.out.println(stringArray2[i] + " is SipUri? " + genericURI.isSipURI() + ">" + genericURI.encode());
        }
    }
}

