/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey register(ServerSocketChannel acceptChannel, int op_accept) throws ClosedChannelException {
        int set = 0;
        SelectSet selectSet = this._selectSet[set];
        synchronized (selectSet) {
            SelectionKey key = acceptChannel.register(this._selectSet[set].getSelector(), 16);
            return key;
        }
    }

    public void doSelect(int acceptorID) throws IOException {
        if (this._selectSet != null && this._selectSet.length > acceptorID && this._selectSet[acceptorID] != null) {
            this._selectSet[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        this._selectSets = selectSets;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    protected abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i].stop();
        }
        super.doStop();
        this._selectSet = null;
    }

    public void doStop(int i) throws Exception {
        this._selectSet[i].stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispatch(SelectChannelEndPoint endpoint) throws IOException {
        boolean dispatch_done = true;
        try {
            if (endpoint.dispatch(this._delaySelectKeyUpdate)) {
                dispatch_done = false;
                dispatch_done = this.dispatch(endpoint);
            }
        }
        finally {
            if (!dispatch_done) {
                Log.warn((String)"dispatch failed!");
                endpoint.undispatch();
            }
        }
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private transient boolean _selecting;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout();
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout();
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doSelect() throws IOException {
            Object endpoint;
            long idle_next = 0L;
            long retry_next = 0L;
            try {
                List[] listArray = this._changes;
                synchronized (this._changes) {
                    List changes = this._changes[this._change];
                    this._change = this._change == 0 ? 1 : 0;
                    this._selecting = true;
                    // ** MonitorExit[var6_3] (shouldn't be in output)
                    for (int i = 0; i < changes.size(); ++i) {
                        try {
                            Object o = changes.get(i);
                            if (o instanceof EndPoint) {
                                SelectChannelEndPoint endpoint2 = (SelectChannelEndPoint)o;
                                endpoint2.syncKey();
                                continue;
                            }
                            if (o instanceof SocketChannel) {
                                SocketChannel channel = (SocketChannel)o;
                                SelectionKey cKey = channel.register(this._selector, 1);
                                endpoint = SelectorManager.this.newEndPoint(channel, this, cKey);
                                if (!SelectorManager.this._delaySelectKeyUpdate) continue;
                                SelectorManager.this.doDispatch((SelectChannelEndPoint)endpoint);
                                continue;
                            }
                            if (!(o instanceof Runnable)) throw new IllegalArgumentException(o.toString());
                            SelectorManager.this.dispatch((Runnable)o);
                            continue;
                        }
                        catch (CancelledKeyException e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                                continue;
                            }
                            Log.debug((Throwable)e);
                        }
                    }
                    changes.clear();
                    SelectSet i = this;
                    synchronized (i) {
                        this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
                        idle_next = this._idleTimeout.getTimeToNext();
                        retry_next = this._retryTimeout.getTimeToNext();
                    }
                    long wait = 1000L;
                    if (wait < 0L || idle_next >= 0L && wait > idle_next) {
                        wait = idle_next;
                    }
                    if (wait < 0L || retry_next >= 0L && wait > retry_next) {
                        wait = retry_next;
                    }
                    if (wait > 0L) {
                        this._selector.select(wait);
                    } else if (wait == 0L) {
                        this._selector.selectNow();
                    } else {
                        this._selector.select();
                    }
                    long now = -1L;
                    if (this._selector == null) return;
                    if (!this._selector.isOpen()) {
                        return;
                    }
                    now = System.currentTimeMillis();
                    this._idleTimeout.setNow(now);
                    this._retryTimeout.setNow(now);
                    Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            block48: {
                                SelectChannelEndPoint endpoint3;
                                block47: {
                                    if (!key.isValid()) {
                                        key.cancel();
                                        endpoint3 = (SelectChannelEndPoint)key.attachment();
                                        if (endpoint3 == null) continue;
                                        endpoint3.close();
                                        SelectorManager.this.endPointClosed(endpoint3);
                                        continue;
                                    }
                                    if (!key.isAcceptable()) break block47;
                                    SocketChannel channel = SelectorManager.this.acceptChannel(key);
                                    if (channel == null) continue;
                                    channel.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.this._selectSet.length;
                                    if (this._nextSet != this._setID) {
                                        SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                        SelectorManager.this._selectSet[this._nextSet].wakeup();
                                        break block48;
                                    } else {
                                        SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                        SelectChannelEndPoint endpoint4 = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                        if (endpoint4 != null) {
                                            SelectorManager.this.doDispatch(endpoint4);
                                        }
                                    }
                                    break block48;
                                }
                                endpoint3 = (SelectChannelEndPoint)key.attachment();
                                if (endpoint3 != null) {
                                    SelectorManager.this.doDispatch(endpoint3);
                                }
                            }
                            key = null;
                        }
                        catch (CancelledKeyException e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                                continue;
                            }
                            Log.ignore((Throwable)e);
                        }
                        catch (Exception e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                            } else {
                                Log.ignore((Throwable)e);
                            }
                            if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                            key.interestOps(0);
                            key.cancel();
                        }
                    }
                    Timeout.Task task = null;
                    SelectSet selectSet = this;
                    synchronized (selectSet) {
                        now = System.currentTimeMillis();
                        this._retryTimeout.setNow(now);
                        this._idleTimeout.setNow(now);
                        task = this._idleTimeout.expired();
                        if (task == null) {
                            task = this._retryTimeout.expired();
                        }
                    }
                    while (task != null) {
                        task.expire();
                        selectSet = this;
                        synchronized (selectSet) {
                            if (this._selector == null) {
                                return;
                            }
                            task = this._idleTimeout.expired();
                            if (task == null) {
                                task = this._retryTimeout.expired();
                            }
                        }
                    }
                    return;
                }
            }
            finally {
                endpoint = this;
                synchronized (endpoint) {
                    this._selecting = false;
                }
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            SelectSet selectSet;
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                Thread.yield();
                selectSet = this;
                synchronized (selectSet) {
                    selecting = this._selecting;
                }
            }
            selectSet = this;
            synchronized (selectSet) {
                Iterator<SelectionKey> iter = this._selector.keys().iterator();
                while (iter.hasNext()) {
                    EndPoint endpoint;
                    SelectionKey key = iter.next();
                    if (key == null || (endpoint = (EndPoint)key.attachment()) == null) continue;
                    try {
                        endpoint.close();
                    }
                    catch (IOException e) {
                        Log.ignore((Throwable)e);
                    }
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                this._selector = null;
            }
        }
    }
}

