/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Sleep
extends Task {
    private boolean failOnError;
    private int seconds;
    private int hours;
    private int minutes;
    private int milliseconds;

    public void setSeconds(int n) {
        this.seconds = n;
    }

    public void setHours(int n) {
        this.hours = n;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public void setMilliseconds(int n) {
        this.milliseconds = n;
    }

    public void doSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    private final long getSleepTime() {
        return (((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000L + (long)this.milliseconds;
    }

    public void validate() throws BuildException {
        if (this.getSleepTime() < 0L) {
            throw new BuildException("Negative sleep periods are not supported");
        }
    }

    public void execute() throws BuildException {
        try {
            this.validate();
            long l = this.getSleepTime();
            this.log("sleeping for " + l + " milliseconds", 3);
            this.doSleep(l);
        }
        catch (Exception exception) {
            if (this.failOnError) {
                throw new BuildException(exception);
            }
            String string = exception.toString();
            this.log(string, 0);
        }
    }

    private final /* synthetic */ void this() {
        this.failOnError = true;
        this.seconds = 0;
        this.hours = 0;
        this.minutes = 0;
        this.milliseconds = 0;
    }

    public Sleep() {
        this.this();
    }
}

