/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;

public class ColibriStatsExtension
extends AbstractPacketExtension {
    public static final String ELEMENT_NAME = "stats";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";

    public ColibriStatsExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public void addStat(Stat stat) {
        this.addChildExtension(stat);
    }

    @Override
    public List<? extends PacketExtension> getChildExtensions() {
        return Collections.unmodifiableList(super.getChildExtensions());
    }

    public static class Stat
    extends AbstractPacketExtension {
        public static final String ELEMENT_NAME = "stat";
        public static final String NAME_ATTR_NAME = "name";
        public static final String VALUE_ATTR_NAME = "value";
        private String name;
        private Object value;

        public Stat() {
            super(ColibriStatsExtension.NAMESPACE, ELEMENT_NAME);
        }

        public Stat(String name, Object value) {
            this();
            this.setName(name);
            this.setValue(value);
        }

        @Override
        public String getElementName() {
            return ELEMENT_NAME;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ColibriStatsExtension.NAMESPACE;
        }

        public Object getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public String toXML() {
            String name = this.getName();
            Object value = this.getValue();
            if (name == null || value == null) {
                return "";
            }
            return "<stat name='" + StringUtils.escapeForXML((String)name) + "' " + VALUE_ATTR_NAME + "='" + StringUtils.escapeForXML((String)value.toString()) + "' />";
        }
    }
}

