/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jitsi.impl.neomedia.rtp.translator.RTCPFeedbackMessageSender;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.videobridge.AudioChannel;
import org.jitsi.videobridge.AudioSilenceMediaDevice;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.log.EventFactory;
import org.jitsi.videobridge.log.LoggingService;
import org.jitsi.videobridge.rtcp.BridgeRTCPTerminationStrategy;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
implements RTPTranslator.WriteFilter {
    private static final Logger logger = Logger.getLogger(Content.class);
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Conference conference;
    private boolean expired = false;
    private long initialLocalSSRC = -1L;
    private long lastActivityTime;
    private final MediaType mediaType;
    private MediaDevice mixer;
    private final String name;
    private Recorder recorder = null;
    private boolean recording = false;
    private String recordingPath = null;
    private RTCPFeedbackMessageSender rtcpFeedbackMessageSender;
    private final Object rtpLevelRelaySyncRoot = new Object();
    private RTPTranslator rtpTranslator;
    private String rtcpTerminationStrategyFQN;
    private String fallbackSrategyFQN;

    public Content(Conference conference, String name) {
        if (conference == null) {
            throw new NullPointerException("conference");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.conference = conference;
        this.conference.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent != null && Conference.ENDPOINTS_PROPERTY_NAME.equals(propertyChangeEvent.getPropertyName())) {
                    Content.this.updateRTCPTerminationStrategy();
                }
            }
        });
        this.name = name;
        this.mediaType = MediaType.parseString((String)this.name);
        LoggingService loggingService = conference.getVideobridge().getLoggingService();
        if (loggingService != null) {
            loggingService.logEvent(EventFactory.contentCreated(name, conference.getID()));
        }
        this.touch();
    }

    public boolean accept(MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
        RtpChannel dst;
        boolean accept = true;
        if (destination != null && (dst = RtpChannel.getChannel(destination)) != null) {
            RtpChannel src = source == null ? null : RtpChannel.getChannel(source);
            accept = dst.rtpTranslatorWillWrite(data, buffer, offset, length, src);
        }
        return accept;
    }

    void askForKeyframes(Collection<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            for (RtpChannel channel : endpoint.getChannels(MediaType.VIDEO)) {
                channel.askForKeyframes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpChannel createRtpChannel(String channelBundleId) throws Exception {
        RtpChannel channel = null;
        do {
            String id = this.generateChannelID();
            Map<String, Channel> map = this.channels;
            synchronized (map) {
                if (!this.channels.containsKey(id)) {
                    switch (this.getMediaType()) {
                        case AUDIO: {
                            channel = new AudioChannel(this, id, channelBundleId);
                            break;
                        }
                        case DATA: {
                            throw new IllegalStateException("mediaType");
                        }
                        case VIDEO: {
                            channel = new VideoChannel(this, id, channelBundleId);
                            break;
                        }
                        default: {
                            channel = new RtpChannel(this, id, channelBundleId);
                        }
                    }
                    this.channels.put(id, channel);
                }
            }
        } while (channel == null);
        if (logger.isInfoEnabled()) {
            Conference conference = this.getConference();
            Videobridge videobridge = conference.getVideobridge();
            logger.info((Object)("Created channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpConnection createSctpConnection(Endpoint endpoint, int sctpPort, String channelBundleId) throws Exception {
        SctpConnection sctpConnection;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            String id = this.generateChannelID();
            sctpConnection = new SctpConnection(id, this, endpoint, sctpPort, channelBundleId);
            this.channels.put(sctpConnection.getID(), sctpConnection);
        }
        return sctpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Content content = this;
        synchronized (content) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        this.setRecording(false, null);
        Conference conference = this.getConference();
        LoggingService loggingService = conference.getVideobridge().getLoggingService();
        if (loggingService != null) {
            loggingService.logEvent(EventFactory.contentExpired(this.name, conference.getID()));
        }
        try {
            conference.expireContent(this);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            for (Channel channel : this.getChannels()) {
                try {
                    channel.expire();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + "!"), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            Object object = this.rtpLevelRelaySyncRoot;
            synchronized (object) {
                if (this.rtpTranslator != null) {
                    this.rtpTranslator.dispose();
                }
                this.rtcpFeedbackMessageSender = null;
            }
            if (logger.isInfoEnabled()) {
                Videobridge videobridge = conference.getVideobridge();
                logger.info((Object)("Expired content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
            }
            throw throwable;
        }
        for (Channel channel : this.getChannels()) {
            try {
                channel.expire();
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + "!"), t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        Object object = this.rtpLevelRelaySyncRoot;
        synchronized (object) {
            if (this.rtpTranslator != null) {
                this.rtpTranslator.dispose();
            }
            this.rtcpFeedbackMessageSender = null;
        }
        if (logger.isInfoEnabled()) {
            Videobridge videobridge = conference.getVideobridge();
            logger.info((Object)("Expired content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireChannel(Channel channel) {
        boolean expireChannel;
        String id = channel.getID();
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            if (((Object)((Object)channel)).equals((Object)this.channels.get(id))) {
                this.channels.remove(id);
                expireChannel = true;
            } else {
                expireChannel = false;
            }
        }
        if (expireChannel) {
            channel.expire();
        }
    }

    void feedKnownSsrcsToSynchronizer() {
        Recorder recorder;
        if (this.isRecording() && (recorder = this.getRecorder()) != null) {
            Synchronizer synchronizer = recorder.getSynchronizer();
            for (Channel channel : this.getChannels()) {
                Endpoint endpoint;
                if (!(channel instanceof RtpChannel) || (endpoint = channel.getEndpoint()) == null) continue;
                for (int s : ((RtpChannel)channel).getReceiveSSRCs()) {
                    long ssrc = (long)s & 0xFFFFFFFFL;
                    synchronizer.setEndpoint(ssrc, endpoint.getID());
                }
            }
        }
    }

    Channel findChannel(long ssrc) {
        for (Channel channel : this.getChannels()) {
            if (!(channel instanceof RtpChannel)) continue;
            RtpChannel rtpChannel = (RtpChannel)channel;
            for (int channelSsrc : rtpChannel.getReceiveSSRCs()) {
                if (ssrc != (0xFFFFFFFFL & (long)channelSsrc)) continue;
                return channel;
            }
        }
        return null;
    }

    Channel findChannelByReceiveSSRC(long receiveSSRC) {
        for (Channel channel : this.getChannels()) {
            if (!(channel instanceof RtpChannel)) continue;
            RtpChannel rtpChannel = (RtpChannel)channel;
            for (int channelReceiveSSRC : rtpChannel.getReceiveSSRCs()) {
                if (receiveSSRC != (0xFFFFFFFFL & (long)channelReceiveSSRC)) continue;
                return channel;
            }
        }
        return null;
    }

    private String generateChannelID() {
        return Long.toHexString(System.currentTimeMillis() + Videobridge.RANDOM.nextLong());
    }

    public BundleContext getBundleContext() {
        return this.getConference().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String id) {
        Channel channel;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            channel = this.channels.get(id);
        }
        if (channel != null) {
            channel.touch();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            return this.channels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel[] getChannels() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            Collection<Channel> values = this.channels.values();
            return values.toArray(new Channel[values.size()]);
        }
    }

    public final Conference getConference() {
        return this.conference;
    }

    long getInitialLocalSSRC() {
        return this.initialLocalSSRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Content content = this;
        synchronized (content) {
            return this.lastActivityTime;
        }
    }

    MediaService getMediaService() {
        return this.getConference().getMediaService();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public MediaDevice getMixer() {
        if (this.mixer == null) {
            AudioSilenceMediaDevice device;
            MediaType mediaType = this.getMediaType();
            AudioSilenceMediaDevice audioSilenceMediaDevice = device = MediaType.AUDIO.equals((Object)mediaType) ? new AudioSilenceMediaDevice() : null;
            if (device == null) {
                throw new UnsupportedOperationException("The mixer type of RTP-level relay is not supported for " + mediaType);
            }
            this.mixer = this.getMediaService().createMixer((MediaDevice)device);
        }
        return this.mixer;
    }

    public final String getName() {
        return this.name;
    }

    public Recorder getRecorder() {
        MediaType mediaType;
        if (this.recorder == null && (MediaType.AUDIO.equals((Object)(mediaType = this.getMediaType())) || MediaType.VIDEO.equals((Object)mediaType))) {
            this.recorder = this.getMediaService().createRecorder(this.getRTPTranslator());
            this.recorder.setEventHandler(this.getConference().getRecorderEventHandler());
        }
        return this.recorder;
    }

    RTCPFeedbackMessageSender getRTCPFeedbackMessageSender() {
        return this.rtcpFeedbackMessageSender;
    }

    public void setRTCPTerminationStrategyFQN(String strategyFQN) {
        this.rtcpTerminationStrategyFQN = strategyFQN;
        this.updateRTCPTerminationStrategy();
    }

    private void updateRTCPTerminationStrategy() {
        String strategyFQN;
        Conference conf = this.conference;
        if (conf == null) {
            return;
        }
        RTPTranslator rtpTranslator = this.rtpTranslator;
        if (rtpTranslator == null) {
            return;
        }
        List<Endpoint> endpoints = conf.getEndpoints();
        if (endpoints != null && endpoints.size() < 3) {
            strategyFQN = this.fallbackSrategyFQN;
            if (StringUtils.isNullOrEmpty((String)strategyFQN)) {
                strategyFQN = this.rtcpTerminationStrategyFQN;
            }
        } else {
            strategyFQN = this.rtcpTerminationStrategyFQN;
        }
        if (StringUtils.isNullOrEmpty((String)strategyFQN)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(strategyFQN);
            RTCPTerminationStrategy oldStrategy = rtpTranslator.getRTCPTerminationStrategy();
            if (clazz.isInstance(oldStrategy)) {
                return;
            }
            RTCPTerminationStrategy strategy = (RTCPTerminationStrategy)clazz.newInstance();
            if (strategy instanceof BridgeRTCPTerminationStrategy) {
                ((BridgeRTCPTerminationStrategy)strategy).setConference(this.conference);
            }
            rtpTranslator.setRTCPTerminationStrategy(strategy);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to configure the RTCP termination strategy", (Throwable)e);
        }
    }

    public void setRTCPTerminationStrategyFromConfiguration() {
        if (!MediaType.VIDEO.equals((Object)this.mediaType)) {
            return;
        }
        ConfigurationService cfg = this.getConference().getVideobridge().getConfigurationService();
        if (cfg != null) {
            String fallbackFQN = cfg.getString("org.jitsi.videobridge.rtcp.fallbackStrategy", "");
            this.setRTCPTerminationFallbackStrategyFQN(fallbackFQN);
            String strategyFQN = cfg.getString("org.jitsi.videobridge.rtcp.strategy", "");
            this.setRTCPTerminationStrategyFQN(strategyFQN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTranslator getRTPTranslator() {
        Object object = this.rtpLevelRelaySyncRoot;
        synchronized (object) {
            if (this.rtpTranslator == null && !this.expired) {
                this.rtpTranslator = this.getMediaService().createRTPTranslator();
                if (this.rtpTranslator != null) {
                    new RTPTranslatorWriteFilter(this.rtpTranslator, this);
                    if (this.rtpTranslator instanceof RTPTranslatorImpl) {
                        RTPTranslatorImpl rtpTranslatorImpl = (RTPTranslatorImpl)this.rtpTranslator;
                        this.initialLocalSSRC = Videobridge.RANDOM.nextInt();
                        rtpTranslatorImpl.setLocalSSRC(this.initialLocalSSRC);
                        if (MediaType.VIDEO.equals((Object)this.getMediaType())) {
                            this.setRTCPTerminationStrategyFromConfiguration();
                        }
                        this.rtcpFeedbackMessageSender = rtpTranslatorImpl.getRtcpFeedbackMessageSender();
                    }
                }
            }
            return this.rtpTranslator;
        }
    }

    @Deprecated
    public SctpConnection getSctpConnection(Endpoint endpoint) {
        return endpoint == null ? null : endpoint.getSctpConnection();
    }

    public SctpConnection getSctpConnection(String id) {
        return (SctpConnection)this.getChannel(id);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean setRecording(boolean recording, String path) {
        this.recordingPath = path;
        if (this.recording != recording) {
            Recorder recorder = this.getRecorder();
            if (recording) {
                recording = recorder != null ? this.startRecorder(recorder) : false;
            } else {
                if (recorder != null) {
                    recorder.stop();
                    this.recorder = null;
                }
                recording = false;
            }
        }
        this.recording = recording;
        return this.recording;
    }

    private boolean startRecorder(Recorder recorder) {
        boolean started = false;
        String format = MediaType.AUDIO.equals((Object)this.getMediaType()) ? "mp3" : null;
        try {
            recorder.start(format, this.recordingPath);
            started = true;
        }
        catch (IOException ioe) {
            logger.error((Object)("Failed to start recorder: " + ioe));
            started = false;
        }
        catch (MediaException me) {
            logger.error((Object)("Failed to start recorder: " + (Object)((Object)me)));
            started = false;
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Content content = this;
        synchronized (content) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    public void setRTCPTerminationFallbackStrategyFQN(String rtcpTerminationFallbackStrategyFQN) {
        this.fallbackSrategyFQN = rtcpTerminationFallbackStrategyFQN;
    }

    private static class RTPTranslatorWriteFilter
    implements RTPTranslator.WriteFilter {
        private final WeakReference<RTPTranslator> rtpTranslator;
        private final WeakReference<RTPTranslator.WriteFilter> writeFilter;

        public RTPTranslatorWriteFilter(RTPTranslator rtpTranslator, RTPTranslator.WriteFilter writeFilter) {
            this.rtpTranslator = new WeakReference<RTPTranslator>(rtpTranslator);
            this.writeFilter = new WeakReference<RTPTranslator.WriteFilter>(writeFilter);
            rtpTranslator.addWriteFilter((RTPTranslator.WriteFilter)this);
        }

        public boolean accept(MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
            RTPTranslator.WriteFilter writeFilter = (RTPTranslator.WriteFilter)this.writeFilter.get();
            boolean accept = true;
            if (writeFilter == null) {
                RTPTranslator rtpTranslator = (RTPTranslator)this.rtpTranslator.get();
                if (rtpTranslator != null) {
                    rtpTranslator.removeWriteFilter((RTPTranslator.WriteFilter)this);
                }
            } else {
                accept = writeFilter.accept(source, buffer, offset, length, destination, data);
            }
            return accept;
        }
    }
}

