/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.protocol;

import java.util.Map;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JitsiMeetConfig {
    private static final Logger logger = Logger.getLogger(JitsiMeetConfig.class);
    public static final String CHANNEL_LAST_N_PNAME = "channelLastN";
    public static final String ADAPTIVE_LAST_N_PNAME = "adaptiveLastN";
    public static final String ADAPTIVE_SIMULCAST_PNAME = "adaptiveSimulcast";
    private final Map<String, String> properties;

    public JitsiMeetConfig(Map<String, String> properties) {
        this.properties = properties;
    }

    public Integer getChannelLastN() {
        return this.getInt(CHANNEL_LAST_N_PNAME);
    }

    public Boolean isAdaptiveLastNEnabled() {
        return this.getBoolean(ADAPTIVE_LAST_N_PNAME);
    }

    public Boolean isAdaptiveSimulcastEnabled() {
        return this.getBoolean(ADAPTIVE_SIMULCAST_PNAME);
    }

    private Boolean getBoolean(String name) {
        String stringValue = this.properties.get(name);
        Boolean boolValue = null;
        if (!StringUtils.isNullOrEmpty((String)stringValue)) {
            boolValue = Boolean.parseBoolean(stringValue);
        }
        return boolValue;
    }

    private Integer getInt(String name) {
        String stringValue = this.properties.get(name);
        Integer intValue = null;
        if (!StringUtils.isNullOrEmpty((String)stringValue)) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("Error parsing: " + name + ", v: " + stringValue), (Throwable)ex);
            }
        }
        return intValue;
    }
}

