/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import org.jitsi.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRCGroup {
    private final SourceGroupPacketExtension group;

    public static List<SSRCGroup> getSSRCGroupsForContent(ContentPacketExtension content) {
        ArrayList<SSRCGroup> groups = new ArrayList<SSRCGroup>();
        RtpDescriptionPacketExtension rtpDescPe = JingleUtils.getRtpDescription((ContentPacketExtension)content);
        if (rtpDescPe == null) {
            return groups;
        }
        List groupExtensions = rtpDescPe.getChildExtensionsOfType(SourceGroupPacketExtension.class);
        for (SourceGroupPacketExtension groupPe : groupExtensions) {
            groups.add(new SSRCGroup(groupPe));
        }
        return groups;
    }

    public SSRCGroup(SourceGroupPacketExtension group) {
        this.group = group;
    }

    public SourceGroupPacketExtension getExtensionCopy() {
        return this.group.copy();
    }

    public SSRCGroup copy() {
        return new SSRCGroup(this.getExtensionCopy());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSRCGroup)) {
            return false;
        }
        SSRCGroup other = (SSRCGroup)obj;
        String semantics = other.group.getSemantics();
        if (StringUtils.isNullOrEmpty((String)semantics) && !StringUtils.isNullOrEmpty((String)this.group.getSemantics())) {
            return false;
        }
        if (!this.group.getSemantics().equals(semantics)) {
            return false;
        }
        for (SourcePacketExtension ssrcToFind : this.group.getSources()) {
            boolean found = false;
            for (SourcePacketExtension ssrc : other.group.getSources()) {
                if (ssrc.getSSRC() != ssrcToFind.getSSRC()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

