/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriAnalyser;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriBuilder;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.MediaSSRCGroupMap;
import org.jitsi.jicofo.SSRCGroup;
import org.jitsi.protocol.JitsiMeetConfig;
import org.jitsi.protocol.xmpp.OperationSetColibriConference;
import org.jitsi.protocol.xmpp.XmppConnection;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationSetColibriConferenceImpl
implements OperationSetColibriConference {
    private static final Logger logger = Logger.getLogger(OperationSetColibriConferenceImpl.class);
    private XmppConnection connection;
    private String jitsiVideobridge;
    private ColibriConferenceIQ conferenceState = new ColibriConferenceIQ();
    private ColibriBuilder colibriBuilder = new ColibriBuilder(this.conferenceState);

    public void initialize(XmppConnection connection) {
        this.connection = connection;
        ProviderManager.getInstance().addIQProvider("conference", "http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
        ProviderManager.getInstance().addIQProvider("jingle", "urn:xmpp:jingle:1", (Object)new JingleIQProvider());
    }

    @Override
    public void setJitsiVideobridge(String videobridgeJid) {
        if (!StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            throw new IllegalStateException("Can not change the bridge on active conference");
        }
        this.jitsiVideobridge = videobridgeJid;
    }

    @Override
    public String getJitsiVideobridge() {
        return this.jitsiVideobridge;
    }

    @Override
    public void setJitsiMeetConfig(JitsiMeetConfig config) {
        this.colibriBuilder.setChannelLastN(config.getChannelLastN());
        this.colibriBuilder.setAdaptiveLastN(config.isAdaptiveLastNEnabled());
        this.colibriBuilder.setAdaptiveSimulcast(config.isAdaptiveSimulcastEnabled());
    }

    @Override
    public String getConferenceId() {
        return this.conferenceState.getID();
    }

    @Override
    public synchronized ColibriConferenceIQ createColibriChannels(boolean useBundle, String endpointName, boolean peerIsInitiator, List<ContentPacketExtension> contents) throws OperationFailedException {
        this.colibriBuilder.reset();
        this.colibriBuilder.addAllocateChannelsReq(useBundle, endpointName, peerIsInitiator, contents);
        ColibriConferenceIQ allocateRequest = this.colibriBuilder.getRequest(this.jitsiVideobridge);
        Packet response = this.connection.sendPacketAndGetReply((Packet)allocateRequest);
        if (response == null) {
            throw new OperationFailedException("Failed to allocate colibri channels: response is null. Maybe the response timed out.", 2);
        }
        if (response.getError() != null) {
            throw new OperationFailedException("Failed to allocate colibri channels: " + response.getError(), 1);
        }
        if (!(response instanceof ColibriConferenceIQ)) {
            throw new OperationFailedException("Failed to allocate colibri channels: response is not a colibri conference", 1);
        }
        ColibriAnalyser analyser = new ColibriAnalyser(this.conferenceState);
        analyser.processChannelAllocResp((ColibriConferenceIQ)response);
        return ColibriAnalyser.getResponseContents((ColibriConferenceIQ)((ColibriConferenceIQ)response), contents);
    }

    @Override
    public void expireChannels(ColibriConferenceIQ channelInfo) {
        this.colibriBuilder.reset();
        this.colibriBuilder.addExpireChannelsReq(channelInfo);
        ColibriConferenceIQ iq = this.colibriBuilder.getRequest(this.jitsiVideobridge);
        if (iq != null) {
            this.connection.sendPacket((Packet)iq);
        }
    }

    @Override
    public void updateTransportInfo(boolean initiator, Map<String, IceUdpTransportPacketExtension> map, ColibriConferenceIQ localChannelsInfo) {
        this.colibriBuilder.reset();
        this.colibriBuilder.addTransportUpdateReq(initiator, map, localChannelsInfo);
        ColibriConferenceIQ conferenceRequest = this.colibriBuilder.getRequest(this.jitsiVideobridge);
        if (conferenceRequest != null) {
            this.connection.sendPacket((Packet)conferenceRequest);
        }
    }

    @Override
    public void updateSsrcGroupsInfo(MediaSSRCGroupMap ssrcGroups, ColibriConferenceIQ localChannelsInfo) {
        ColibriConferenceIQ updateIq = new ColibriConferenceIQ();
        updateIq.setID(this.conferenceState.getID());
        updateIq.setType(IQ.Type.SET);
        updateIq.setTo(this.jitsiVideobridge);
        boolean updateNeeded = false;
        for (ColibriConferenceIQ.Content content : localChannelsInfo.getContents()) {
            String contentName = content.getName();
            if ("video".compareToIgnoreCase(contentName) != 0) continue;
            ColibriConferenceIQ.Content reqContent = new ColibriConferenceIQ.Content(content.getName());
            boolean hasChannels = false;
            for (ColibriConferenceIQ.Channel channel : content.getChannels()) {
                ColibriConferenceIQ.Channel reqChannel = new ColibriConferenceIQ.Channel();
                reqChannel.setID(channel.getID());
                List<SSRCGroup> groups = ssrcGroups.getSSRCGroupsForMedia(content.getName());
                for (SSRCGroup group : groups) {
                    try {
                        reqChannel.addSourceGroup(group.getExtensionCopy());
                        hasChannels = true;
                        updateNeeded = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error copying extension", (Throwable)e);
                    }
                }
                if (groups.isEmpty()) {
                    reqChannel.addSourceGroup(SourceGroupPacketExtension.createSimulcastGroup());
                    hasChannels = true;
                    updateNeeded = true;
                }
                reqContent.addChannel(reqChannel);
            }
            if (!hasChannels) continue;
            updateIq.addContent(reqContent);
        }
        if (updateNeeded) {
            this.connection.sendPacketAndGetReply((Packet)updateIq);
        }
    }

    @Override
    public void updateBundleTransportInfo(boolean initiator, IceUdpTransportPacketExtension transport, ColibriConferenceIQ localChannelsInfo) {
        this.colibriBuilder.reset();
        this.colibriBuilder.addBundleTransportUpdateReq(initiator, transport, localChannelsInfo);
        ColibriConferenceIQ conferenceRequest = this.colibriBuilder.getRequest(this.jitsiVideobridge);
        if (conferenceRequest != null) {
            this.connection.sendPacket((Packet)conferenceRequest);
        }
    }

    @Override
    public void expireConference() {
        this.colibriBuilder.reset();
        if (StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            logger.info((Object)"Nothing to expire - no conference allocated yet");
            return;
        }
        this.colibriBuilder.addExpireChannelsReq(this.conferenceState);
        ColibriConferenceIQ colibriRequest = this.colibriBuilder.getRequest(this.jitsiVideobridge);
        if (colibriRequest != null) {
            this.connection.sendPacket((Packet)colibriRequest);
        }
        this.conferenceState = new ColibriConferenceIQ();
    }

    @Override
    public boolean muteParticipant(ColibriConferenceIQ channelsInfo, boolean mute) {
        ColibriConferenceIQ request = new ColibriConferenceIQ();
        request.setID(this.conferenceState.getID());
        ColibriConferenceIQ.Content audioContent = channelsInfo.getContent("audio");
        if (audioContent == null) {
            logger.error((Object)("Failed to mute - no audio content. Conf ID: " + request.getID()));
            return false;
        }
        ColibriConferenceIQ.Content contentRequest = new ColibriConferenceIQ.Content(audioContent.getName());
        for (ColibriConferenceIQ.Channel channel : audioContent.getChannels()) {
            ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
            channelRequest.setID(channel.getID());
            if (mute) {
                channelRequest.setDirection(MediaDirection.SENDONLY);
            } else {
                channelRequest.setDirection(MediaDirection.SENDRECV);
            }
            contentRequest.addChannel(channelRequest);
        }
        if (contentRequest.getChannelCount() == 0) {
            logger.error((Object)("Failed to mute - no channels to modify. ConfID:" + request.getID()));
            return false;
        }
        request.setType(IQ.Type.SET);
        request.setTo(this.jitsiVideobridge);
        request.addContent(contentRequest);
        this.connection.sendPacket((Packet)request);
        return true;
    }
}

