/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.net.DatagramPacket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;

public abstract class TransformInputStream<T>
extends RTPConnectorInputStream<T> {
    private PacketTransformer transformer;

    protected TransformInputStream(T socket) {
        super(socket);
    }

    @Override
    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        PacketTransformer transformer = this.getTransformer();
        RawPacket[] pkts = super.createRawPacket(datagramPacket);
        for (int i = 0; i < pkts.length; ++i) {
            if (pkts[i] == null || !pkts[i].isInvalid()) continue;
            pkts[i] = null;
        }
        return transformer == null ? pkts : transformer.reverseTransform(pkts);
    }

    public PacketTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(PacketTransformer transformer) {
        this.transformer = transformer;
    }
}

