/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile.RtpdumpFileReader;
import org.jitsi.util.Logger;

public class RtpdumpStream
extends AbstractVideoPullBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(RtpdumpStream.class);
    private final long CLOCK_RATE;
    private long lastRtpTimestamp = -1L;
    private boolean lastReadWasMarked = true;
    private RtpdumpFileReader rtpFileReader;
    private long timestamp;

    RtpdumpStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        Format format = this.getFormat();
        if (format instanceof AudioFormat) {
            this.CLOCK_RATE = (long)((AudioFormat)format).getSampleRate();
        } else if (format instanceof VideoFormat) {
            this.CLOCK_RATE = (long)((VideoFormat)format).getFrameRate();
        } else {
            logger.warn("Unknown format. Creating RtpdumpStream with clockrate 1 000 000 000.");
            this.CLOCK_RATE = 1000000000L;
        }
        String rtpdumpFilePath = dataSource.getLocator().getRemainder();
        this.rtpFileReader = new RtpdumpFileReader(rtpdumpFilePath);
    }

    @Override
    protected void doRead(Buffer buffer) throws IOException {
        Format format = buffer.getFormat();
        if (format == null && (format = this.getFormat()) != null) {
            buffer.setFormat(format);
        }
        RawPacket rtpPacket = this.rtpFileReader.getNextPacket(true);
        byte[] data = rtpPacket.getPayload();
        buffer.setData(data);
        buffer.setOffset(rtpPacket.getOffset());
        buffer.setLength(rtpPacket.getPayloadLength());
        buffer.setFlags(32896);
        if (this.lastReadWasMarked) {
            this.timestamp = System.nanoTime();
        }
        this.lastReadWasMarked = rtpPacket.isPacketMarked();
        if (this.lastReadWasMarked) {
            buffer.setFlags(buffer.getFlags() | 0x800);
        }
        buffer.setTimeStamp(this.timestamp);
        if (this.lastRtpTimestamp == -1L) {
            this.lastRtpTimestamp = 0xFFFFFFFFL & rtpPacket.getTimestamp();
            return;
        }
        long previous = this.lastRtpTimestamp;
        this.lastRtpTimestamp = 0xFFFFFFFFL & rtpPacket.getTimestamp();
        long rtpDiff = this.lastRtpTimestamp - previous;
        long nanos = rtpDiff * 1000L * 1000L * 1000L / this.CLOCK_RATE;
        if (nanos > 0L) {
            try {
                Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

