/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.Buffer;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.util.MediaThread;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.DatagramPacketListener;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.protocol.PushBufferStreamAdapter;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public abstract class RTPConnectorInputStream<T>
implements PushSourceStream {
    private static final Object[] EMPTY_CONTROLS = new Object[0];
    private static final Logger logger = Logger.getLogger(RTPConnectorInputStream.class);
    public static final int PACKET_RECEIVE_BUFFER_LENGTH = 4096;
    private final byte[] buffer;
    private boolean closed;
    private DatagramPacketFilter[] datagramPacketFilters;
    private DatagramPacketListener[] datagramPacketListeners;
    private boolean enabled;
    private boolean ioError;
    private long numberOfReceivedBytes;
    private RawPacket pkt;
    private final Object pktSyncRoot;
    private final PushBufferStream pushBufferStream;
    private final Queue<RawPacket[]> rawPacketArrayPool;
    private final Queue<RawPacket> rawPacketPool;
    private Thread receiveThread;
    protected final T socket;
    private SourceTransferHandler transferHandler;

    private static <T> T[] add(T[] array, Class<T> componentType, T element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (array == null) {
            array = (Object[])Array.newInstance(componentType, 1);
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!element.equals(array[i])) continue;
                return array;
            }
            Object[] newArray = (Object[])Array.newInstance(componentType, array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            array = newArray;
        }
        array[array.length - 1] = element;
        return array;
    }

    public static void setThreadPriority(Thread thread, int priority) {
        int oldPriority = thread.getPriority();
        if (priority != oldPriority) {
            int newPriority;
            RuntimeException throwable = null;
            try {
                thread.setPriority(priority);
            }
            catch (IllegalArgumentException iae) {
                throwable = iae;
            }
            catch (SecurityException se) {
                throwable = se;
            }
            if (throwable != null) {
                logger.warn("Failed to use Thread priority: " + priority);
            }
            if (logger.isDebugEnabled() && priority != (newPriority = thread.getPriority())) {
                logger.debug("Did not change Thread priority from " + oldPriority + " to " + priority + ", " + newPriority + " instead.");
            }
        }
    }

    protected RTPConnectorInputStream(T socket) {
        block5: {
            this.buffer = new byte[4096];
            this.enabled = true;
            this.ioError = false;
            this.numberOfReceivedBytes = 0L;
            this.pktSyncRoot = new Object();
            this.rawPacketArrayPool = new LinkedBlockingQueue<RawPacket[]>();
            this.rawPacketPool = new LinkedBlockingQueue<RawPacket>();
            this.socket = socket;
            if (this.socket == null) {
                this.closed = true;
            } else {
                this.closed = false;
                try {
                    this.setReceiveBufferSize(65535);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
        }
        this.addDatagramPacketFilter(new DatagramPacketFilter(){
            private long numberOfPackets = 0L;

            public boolean accept(DatagramPacket p) {
                PacketLoggingService packetLogging;
                ++this.numberOfPackets;
                if (RTPConnectorOutputStream.logPacket(this.numberOfPackets) && (packetLogging = LibJitsi.getPacketLoggingService()) != null && packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) {
                    RTPConnectorInputStream.this.doLogPacket(p);
                }
                return true;
            }
        });
        this.pushBufferStream = new PushBufferStreamAdapter(this, null){

            @Override
            protected int doRead(Buffer buffer, byte[] data, int offset, int length) throws IOException {
                return RTPConnectorInputStream.this.read(buffer, data, offset, length);
            }
        };
        this.maybeStartReceiveThread();
    }

    private boolean accept(DatagramPacket p) {
        boolean accept;
        if (this.enabled) {
            DatagramPacketFilter[] filters = this.getDatagramPacketFilters();
            if (filters == null) {
                accept = true;
            } else {
                accept = true;
                for (DatagramPacketFilter filter : filters) {
                    try {
                        if (filter.accept(p)) continue;
                        accept = false;
                        break;
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
        } else {
            accept = false;
            if (logger.isTraceEnabled() && !this.closed) {
                logger.trace("Will drop received packet because this is disabled: " + p.getLength() + " bytes.");
            }
        }
        return accept;
    }

    public synchronized void addDatagramPacketFilter(DatagramPacketFilter datagramPacketFilter) {
        this.datagramPacketFilters = RTPConnectorInputStream.add(this.datagramPacketFilters, DatagramPacketFilter.class, datagramPacketFilter);
    }

    public synchronized void addDatagramPacketListener(DatagramPacketListener datagramPacketListener) {
        this.datagramPacketListeners = RTPConnectorInputStream.add(this.datagramPacketListeners, DatagramPacketListener.class, datagramPacketListener);
    }

    public synchronized void close() {
        this.closed = true;
        if (this.socket != null) {
            try {
                if (this.socket instanceof Closeable) {
                    ((Closeable)this.socket).close();
                } else if (this.socket instanceof DatagramSocket) {
                    ((DatagramSocket)this.socket).close();
                } else if (this.socket instanceof Socket) {
                    ((Socket)this.socket).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        RawPacket pkt;
        RawPacket[] pkts = this.rawPacketArrayPool.poll();
        if (pkts == null) {
            pkts = new RawPacket[1];
        }
        if ((pkt = this.rawPacketPool.poll()) == null) {
            pkt = new RawPacket();
        }
        byte[] buffer = pkt.getBuffer();
        int length = datagramPacket.getLength();
        if (buffer == null || buffer.length < length) {
            buffer = new byte[length];
            pkt.setBuffer(buffer);
        }
        System.arraycopy(datagramPacket.getData(), datagramPacket.getOffset(), buffer, 0, length);
        pkt.setBuffer(buffer);
        pkt.setOffset(0);
        pkt.setLength(length);
        pkt.setFlags(0);
        pkts[0] = pkt;
        return pkts;
    }

    protected abstract void doLogPacket(DatagramPacket var1);

    @Override
    public boolean endOfStream() {
        return false;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Object getControl(String controlType) {
        if (PushBufferStream.class.getName().equals(controlType)) {
            return this.pushBufferStream;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        return EMPTY_CONTROLS;
    }

    protected synchronized DatagramPacketFilter[] getDatagramPacketFilters() {
        return this.datagramPacketFilters;
    }

    protected synchronized DatagramPacketListener[] getDatagramPacketListeners() {
        return this.datagramPacketListeners;
    }

    @Override
    public int getMinimumTransferSize() {
        return 2048;
    }

    public long getNumberOfReceivedBytes() {
        return this.numberOfReceivedBytes;
    }

    private synchronized void maybeStartReceiveThread() {
        if (this.receiveThread == null) {
            if (this.socket != null && !this.closed && this.transferHandler != null) {
                this.receiveThread = new Thread(){

                    @Override
                    public void run() {
                        RTPConnectorInputStream.this.runInReceiveThread();
                    }
                };
                this.receiveThread.setDaemon(true);
                this.receiveThread.setName(RTPConnectorInputStream.class.getName() + ".receiveThread");
                RTPConnectorInputStream.setThreadPriority(this.receiveThread, MediaThread.getNetworkPriority());
                this.receiveThread.start();
            }
        } else {
            this.notifyAll();
        }
    }

    private void poolRawPacket(RawPacket pkt) {
        pkt.setFlags(0);
        pkt.setLength(0);
        pkt.setOffset(0);
        this.rawPacketPool.offer(pkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int pktLength;
        RawPacket pkt;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.ioError) {
            return -1;
        }
        Object object = this.pktSyncRoot;
        synchronized (object) {
            pkt = this.pkt;
            this.pkt = null;
        }
        if (pkt == null) {
            pktLength = 0;
        } else {
            boolean poolPkt = true;
            try {
                pktLength = pkt.getLength();
                if (length < pktLength) {
                    poolPkt = false;
                    throw new IOException("Input buffer not big enough for " + pktLength);
                }
                byte[] pktBuffer = pkt.getBuffer();
                if (pktBuffer == null) {
                    throw new NullPointerException("pkt.buffer null, pkt.length " + pktLength + ", pkt.offset " + pkt.getOffset());
                }
                System.arraycopy(pkt.getBuffer(), pkt.getOffset(), data, offset, pktLength);
                if (buffer != null) {
                    buffer.setFlags(pkt.getFlags());
                }
            }
            finally {
                if (!poolPkt) {
                    Object object2 = this.pktSyncRoot;
                    synchronized (object2) {
                        if (this.pkt == null) {
                            this.pkt = pkt;
                        } else {
                            poolPkt = true;
                        }
                    }
                }
                if (poolPkt) {
                    this.poolRawPacket(pkt);
                }
            }
        }
        return pktLength;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.read(null, buffer, offset, length);
    }

    protected abstract void receive(DatagramPacket var1) throws IOException;

    private void runInReceiveThread() {
        DatagramPacket p = new DatagramPacket(this.buffer, 0, 4096);
        while (!this.closed) {
            if (OSUtils.IS_ANDROID) {
                p.setLength(4096);
            }
            try {
                this.receive(p);
            }
            catch (IOException e) {
                this.ioError = true;
                break;
            }
            this.numberOfReceivedBytes += (long)p.getLength();
            if (!this.accept(p)) continue;
            RawPacket[] pkts = this.createRawPacket(p);
            try {
                this.updateDatagramPacketListeners(p);
                this.transferData(pkts);
            }
            finally {
                this.rawPacketArrayPool.offer(pkts);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (logger.isDebugEnabled()) {
            logger.debug("setEnabled: " + enabled);
        }
        this.enabled = enabled;
    }

    public void setPriority(int priority) {
    }

    protected abstract void setReceiveBufferSize(int var1) throws IOException;

    @Override
    public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
        if (this.transferHandler != transferHandler) {
            this.transferHandler = transferHandler;
            this.maybeStartReceiveThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferData(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket oldPkt;
            RawPacket pkt = pkts[i];
            pkts[i] = null;
            if (pkt == null) continue;
            if (pkt.isInvalid()) {
                this.poolRawPacket(pkt);
                continue;
            }
            Object object = this.pktSyncRoot;
            synchronized (object) {
                oldPkt = this.pkt;
                this.pkt = pkt;
            }
            if (oldPkt != null) {
                this.poolRawPacket(oldPkt);
            }
            if (this.transferHandler == null || this.closed) continue;
            try {
                this.transferHandler.transferData(this);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn("An RTP packet may have not been fully handled.", t);
            }
        }
    }

    private void updateDatagramPacketListeners(DatagramPacket p) {
        block8: {
            try {
                DatagramPacketListener[] listeners = this.getDatagramPacketListeners();
                if (listeners != null && listeners.length != 0) {
                    for (DatagramPacketListener listener : listeners) {
                        try {
                            listener.update(this, p);
                        }
                        catch (Throwable t) {
                            if (t instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block8;
                throw (ThreadDeath)t;
            }
        }
    }
}

