/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.gui.event;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.event.MetaContactQueryEvent;
import net.java.sip.communicator.service.gui.event.MetaContactQueryListener;
import net.java.sip.communicator.service.gui.event.MetaContactQueryStatusEvent;
import net.java.sip.communicator.service.gui.event.MetaGroupQueryEvent;

public class MetaContactQuery {
    private boolean isCanceled = false;
    private int resultCount = 0;
    private final List<MetaContactQueryListener> queryListeners = new LinkedList<MetaContactQueryListener>();

    public void cancel() {
        this.isCanceled = true;
        this.queryListeners.clear();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public void setInitialResultCount(int resultCount) {
        this.resultCount = resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactQueryListener(MetaContactQueryListener l) {
        List<MetaContactQueryListener> list = this.queryListeners;
        synchronized (list) {
            this.queryListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactQueryListener(MetaContactQueryListener l) {
        List<MetaContactQueryListener> list = this.queryListeners;
        synchronized (list) {
            this.queryListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireQueryEvent(MetaContact metaContact) {
        LinkedList<MetaContactQueryListener> listeners;
        ++this.resultCount;
        MetaContactQueryEvent event = new MetaContactQueryEvent(this, metaContact);
        List<MetaContactQueryListener> list = this.queryListeners;
        synchronized (list) {
            listeners = new LinkedList<MetaContactQueryListener>(this.queryListeners);
        }
        for (MetaContactQueryListener listener : listeners) {
            listener.metaContactReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireQueryEvent(MetaContactGroup metaGroup) {
        LinkedList<MetaContactQueryListener> listeners;
        MetaGroupQueryEvent event = new MetaGroupQueryEvent(this, metaGroup);
        List<MetaContactQueryListener> list = this.queryListeners;
        synchronized (list) {
            listeners = new LinkedList<MetaContactQueryListener>(this.queryListeners);
        }
        Iterator listenersIter = listeners.iterator();
        while (listenersIter.hasNext()) {
            ((MetaContactQueryListener)listenersIter.next()).metaGroupReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireQueryEvent(int queryStatus) {
        LinkedList<MetaContactQueryListener> listeners;
        MetaContactQueryStatusEvent event = new MetaContactQueryStatusEvent(this, queryStatus);
        List<MetaContactQueryListener> list = this.queryListeners;
        synchronized (list) {
            listeners = new LinkedList<MetaContactQueryListener>(this.queryListeners);
        }
        Iterator listenersIter = listeners.iterator();
        while (listenersIter.hasNext()) {
            ((MetaContactQueryListener)listenersIter.next()).metaContactQueryStatusChanged(event);
        }
    }
}

