/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStatsExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStatsIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.GracefulShutdownIQ;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.xmpp.ConferenceIq;
import org.jitsi.jicofo.xmpp.ConferenceIqProvider;
import org.jitsi.jicofo.xmpp.IQUtils;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.osgi.framework.BundleContext;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.IQ;

public class FocusComponent
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(FocusComponent.class);
    public static final String SHUTDOWN_ALLOWED_JID_PNAME = "org.jitsi.focus.shutdown.ALLOWED_JID";
    private final String shutdownAllowedJid;
    private final boolean isFocusAnonymous;
    private FocusManager focusManager;

    public FocusComponent(boolean anonymousFocus) {
        this.isFocusAnonymous = anonymousFocus;
        this.shutdownAllowedJid = FocusBundleActivator.getConfigService().getString(SHUTDOWN_ALLOWED_JID_PNAME);
        new ConferenceIqProvider();
        new ColibriIQProvider();
    }

    public void init() {
        this.focusManager = (FocusManager)ServiceUtils.getService((BundleContext)FocusBundleActivator.bundleContext, FocusManager.class);
        this.focusManager.start();
    }

    public void dispose() {
        this.focusManager.stop();
    }

    public String getDescription() {
        return "Manages Jitsi Meet conferences";
    }

    public String getName() {
        return "Jitsi Meet Focus";
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[]{"http://jitsi.org/protocol/focus"};
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        try {
            org.jivesoftware.smack.packet.IQ smackIq = IQUtils.convert(iq);
            if (smackIq instanceof ColibriStatsIQ) {
                ColibriStatsIQ colibriStatsQuery = (ColibriStatsIQ)smackIq;
                ColibriStatsIQ statsReply = new ColibriStatsIQ();
                statsReply.setType(IQ.Type.RESULT);
                statsReply.setPacketID(iq.getID());
                statsReply.setTo(iq.getFrom().toString());
                int conferenceCount = this.focusManager.getConferenceCount();
                statsReply.addStat(new ColibriStatsExtension.Stat("conferences", (Object)Integer.toString(conferenceCount)));
                statsReply.addStat(new ColibriStatsExtension.Stat("graceful_shutdown", (Object)(this.focusManager.isShutdownInProgress() ? "true" : "false")));
                return IQUtils.convert((org.jivesoftware.smack.packet.IQ)statsReply);
            }
            return super.handleIQGet(iq);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public IQ handleIQSet(IQ iq) throws Exception {
        try {
            org.jivesoftware.smack.packet.IQ smackIq = IQUtils.convert(iq);
            if (smackIq instanceof ConferenceIq) {
                ConferenceIq query = (ConferenceIq)smackIq;
                ConferenceIq response = new ConferenceIq();
                String room = query.getRoom();
                logger.info((Object)("Focus request for room: " + room));
                if (this.focusManager.isShutdownInProgress() && this.focusManager.getConference(room) == null) {
                    org.jivesoftware.smack.packet.IQ smackReply = ColibriConferenceIQ.createGracefulShutdownErrorResponse((org.jivesoftware.smack.packet.IQ)query);
                    return IQUtils.convert(smackReply);
                }
                boolean ready = this.focusManager.conferenceRequest(room, query.getPropertiesMap());
                if (!this.isFocusAnonymous) {
                    ready = true;
                }
                response.setType(IQ.Type.RESULT);
                response.setPacketID(query.getPacketID());
                response.setFrom(query.getTo());
                response.setTo(query.getFrom());
                response.setRoom(query.getRoom());
                response.setReady(ready);
                return IQUtils.convert(response);
            }
            if (smackIq instanceof GracefulShutdownIQ) {
                GracefulShutdownIQ gracefulShutdownIQ = (GracefulShutdownIQ)smackIq;
                String from = gracefulShutdownIQ.getFrom();
                if (StringUtils.isNullOrEmpty((String)this.shutdownAllowedJid) || !this.shutdownAllowedJid.equals(from)) {
                    XMPPError forbiddenError = new XMPPError(XMPPError.Condition.forbidden);
                    logger.warn((Object)("Rejected shutdown request from: " + from));
                    return IQUtils.convert(org.jivesoftware.smack.packet.IQ.createErrorResponse((org.jivesoftware.smack.packet.IQ)smackIq, (XMPPError)forbiddenError));
                }
                logger.info((Object)("Accepted shutdown request from: " + from));
                this.focusManager.enableGracefulShutdownMode();
                return IQUtils.convert(org.jivesoftware.smack.packet.IQ.createResultIQ((org.jivesoftware.smack.packet.IQ)smackIq));
            }
            return super.handleIQSet(iq);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
    }
}

