/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashSet<T>
extends AbstractSet<T> {
    private WeakHashMap<T, Boolean> map;

    public WeakHashSet() {
        this.map = new WeakHashMap();
    }

    public WeakHashSet(Collection<T> c) {
        this.map = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(T o) {
        return this.map.put(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == Boolean.TRUE;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

