/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;

public class SsiDataCmd
extends SsiCommand {
    public static final int VERSION_DEFAULT = 0;
    private final int version;
    private final SsiItem[] items;
    private final long lastmod;

    protected SsiDataCmd(SnacPacket snacPacket) {
        super(6);
        SsiItem ssiItem;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.version = BinaryTools.getUByte(byteBlock, 0);
        int n = BinaryTools.getUShort(byteBlock, 1);
        LinkedList<SsiItem> linkedList = new LinkedList<SsiItem>();
        ByteBlock byteBlock2 = byteBlock.subBlock(3);
        for (int i = 0; i < n && (ssiItem = SsiItem.readSsiItem(byteBlock2)) != null; ++i) {
            linkedList.add(ssiItem);
            byteBlock2 = byteBlock2.subBlock(ssiItem.getTotalSize());
        }
        this.items = linkedList.toArray(new SsiItem[0]);
        this.lastmod = BinaryTools.getUInt(byteBlock2, 0);
    }

    public SsiDataCmd(SsiItem[] ssiItemArray, long l) {
        this(0, ssiItemArray, l);
    }

    public SsiDataCmd(int n, SsiItem[] ssiItemArray, long l) {
        super(6);
        DefensiveTools.checkRange(n, "version", 0);
        DefensiveTools.checkNull(ssiItemArray, "items");
        DefensiveTools.checkRange(l, "lastmod", 0);
        this.version = n;
        this.items = (SsiItem[])ssiItemArray.clone();
        this.lastmod = l;
    }

    public final int getSsiVersion() {
        return this.version;
    }

    public final SsiItem[] getItems() {
        return (SsiItem[])this.items.clone();
    }

    public final long getLastModDate() {
        return this.lastmod;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.version);
        BinaryTools.writeUShort(outputStream, this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].write(outputStream);
        }
        BinaryTools.writeUInt(outputStream, this.lastmod);
    }

    public String toString() {
        return "SsiDataCmd (ssi version=" + this.version + "): " + this.items.length + " items, modified " + new Date(this.lastmod * 1000L);
    }
}

