/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.support;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.openymsg.support.MessageDecoderSettings;

public class MessageElement {
    public static final int NULL = -2;
    public static final int ROOT = -1;
    public static final int TEXT = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int COLOUR_INDEX = 3;
    public static final int UNDERLINE = 4;
    public static final int FONT = 5;
    public static final int FADE = 6;
    public static final int ALT = 7;
    public static final int COLOUR_ABS = 8;
    public static final int COLOUR_NAME = 9;
    protected int type;
    protected List<MessageElement> children;
    protected int fontSize;
    protected String fontFace;
    protected String text;
    protected Color[] transition;
    protected Color colour;
    private MessageDecoderSettings settings;
    static final String[] COLOUR_INDEXES = new String[]{"black", "blue", "cyan", "pink", "green", "gray", "purple", "orange", "red", "brown", "yellow"};
    static final Color[] COLOUR_OBJECTS = new Color[]{Color.black, Color.blue, Color.cyan, Color.pink, Color.green, Color.gray, Color.magenta, Color.orange, Color.red, Color.lightGray, Color.yellow};

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n) {
        this.settings = messageDecoderSettings;
        this.type = n;
        this.children = new ArrayList<MessageElement>();
    }

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n, String string) {
        this(messageDecoderSettings, n);
        switch (n) {
            case 0: {
                this.text = string;
                break;
            }
            case 5: {
                this.fontFace = this._attr(string, "face");
                String string2 = this._attr(string, "size");
                if (string2 != null) {
                    try {
                        this.fontSize = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                }
                if (this.fontFace == null) {
                    this.type = -2;
                }
                if (this.settings == null) break;
                if (this.settings.overMaxFontSize >= 0 && this.fontSize > this.settings.overMaxFontSize) {
                    this.fontSize = this.settings.overMaxFontSize;
                }
                if (this.settings.overMinFontSize >= 0 && this.fontSize < this.settings.overMinFontSize) {
                    this.fontSize = this.settings.overMinFontSize;
                }
                if (this.settings.overFontFace == null) break;
                this.fontFace = this.settings.overFontFace;
                break;
            }
            case 6: 
            case 7: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                this.transition = new Color[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.countTokens() > 0) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("#")) {
                        string3 = string3.substring(1);
                    }
                    try {
                        this.transition[n2++] = new Color(Integer.parseInt(string3, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.transition[n2 - 1] = Color.black;
                    }
                }
                break;
            }
            case 3: {
                this.colour = COLOUR_OBJECTS[string.charAt(0) - 48];
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
                break;
            }
            case 8: {
                this.colour = new Color(Integer.parseInt(string, 16));
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
            }
        }
    }

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n, int n2) {
        this(messageDecoderSettings, n);
        switch (n) {
            case 9: {
                this.colour = COLOUR_OBJECTS[n2];
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
            }
        }
    }

    private String _attr(String string, String string2) {
        string2 = string2 + "=\"";
        String string3 = string.toLowerCase();
        int n = string3.indexOf(string2);
        if (n >= 0) {
            if ((n = (string = string.substring(n + string2.length())).indexOf("\"")) >= 0) {
                string = string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    static int whichColourName(String string) {
        for (int i = 0; i < COLOUR_INDEXES.length; ++i) {
            if (!string.equals(COLOUR_INDEXES[i])) continue;
            return i;
        }
        return -1;
    }

    boolean colourEquals(int n) {
        return this.colour == COLOUR_OBJECTS[n];
    }

    int childTextSize() {
        int n = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = this.children.get(i);
            if (messageElement.type == 0) {
                n += messageElement.text.length();
                continue;
            }
            n += messageElement.childTextSize();
        }
        return n;
    }

    void addChild(MessageElement messageElement) {
        this.children.add(messageElement);
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toHTML(stringBuffer);
        return stringBuffer.toString();
    }

    private void toHTML(StringBuffer stringBuffer) {
        switch (this.type) {
            case -2: {
                stringBuffer.append("<span>");
                break;
            }
            case 0: {
                stringBuffer.append(this.text);
                break;
            }
            case 1: {
                stringBuffer.append("<b>");
                break;
            }
            case 2: {
                stringBuffer.append("<i>");
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                stringBuffer.append("<font color=\"#").append("" + this.colour.getRGB()).append("\">");
                break;
            }
            case 4: {
                stringBuffer.append("<u>");
                break;
            }
            case 5: {
                stringBuffer.append("<font face=\"" + this.fontFace + "\" size=\"" + this.fontSize + "\">");
                break;
            }
            case 6: {
                stringBuffer.append("<span>");
                break;
            }
            case 7: {
                stringBuffer.append("<span>");
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = this.children.get(i);
            messageElement.toHTML(stringBuffer);
        }
        switch (this.type) {
            case -2: {
                stringBuffer.append("</span>");
                break;
            }
            case 1: {
                stringBuffer.append("</b>");
                break;
            }
            case 2: {
                stringBuffer.append("</i>");
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                stringBuffer.append("</font>");
                break;
            }
            case 4: {
                stringBuffer.append("</u>");
                break;
            }
            case 5: {
                stringBuffer.append("</font>");
                break;
            }
            case 6: {
                stringBuffer.append("</span>");
                break;
            }
            case 7: {
                stringBuffer.append("</span>");
            }
        }
    }

    public String toText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toText(stringBuffer);
        return stringBuffer.toString();
    }

    private void toText(StringBuffer stringBuffer) {
        if (this.type == 0) {
            stringBuffer.append(this.text);
        }
        for (MessageElement messageElement : this.children) {
            messageElement.toText(stringBuffer);
        }
    }

    public String toString() {
        switch (this.type) {
            case -2: {
                return "[Null]";
            }
            case -1: {
                return "[Root]";
            }
            case 0: {
                return "Text:" + this.text;
            }
            case 1: {
                return "<b>";
            }
            case 2: {
                return "<i>";
            }
            case 3: {
                return "<col @" + this.colour + ">";
            }
            case 4: {
                return "<u>";
            }
            case 5: {
                return "<font " + this.fontFace + ":" + this.fontSize + ">";
            }
            case 6: {
                return "<fade " + Arrays.toString(this.transition) + ">";
            }
            case 7: {
                return "<alt " + Arrays.toString(this.transition) + ">";
            }
            case 8: {
                return "<col #" + this.colour + ">";
            }
            case 9: {
                return "<col name #" + this.colour + ">";
            }
        }
        return "?";
    }
}

