/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import ymsg.network.DebugInputStream;
import ymsg.network.DebugOutputStream;
import ymsg.network.NetworkConstants;
import ymsg.network.Util;

class HTTPConnection
implements NetworkConstants {
    protected Socket socket;
    protected PushbackInputStream pbis;
    protected DataOutputStream dos;
    private DebugInputStream dbis = null;
    protected String me;
    private boolean eof = false;
    private String lineEnd = "\r\n";

    HTTPConnection(String method, URL u, boolean unix) throws IOException {
        String proxyAuthContent;
        String headerLine;
        int port;
        String host;
        if (unix) {
            this.lineEnd = "\n";
        }
        if ((host = Util.httpProxyHost()) == null || this.doNotProxy(u.getHost())) {
            host = u.getHost();
            port = u.getPort();
            if (port <= -1) {
                port = 80;
            }
            headerLine = method + " " + u.getFile() + " HTTP/1.0";
            proxyAuthContent = null;
        } else {
            port = Util.httpProxyPort();
            headerLine = method + " " + u.toString() + " HTTP/1.0";
            proxyAuthContent = Util.httpProxyAuth();
        }
        this.me = "HTTPConnection to:" + host + ":" + port + " for:[" + headerLine + "]";
        this.socket = new Socket(host, port);
        this.openStreams();
        this.println(headerLine);
        if (proxyAuthContent != null) {
            this.println("Proxy-Authorization: " + proxyAuthContent);
        }
    }

    HTTPConnection(String method, URL u) throws IOException {
        this(method, u, false);
    }

    private void openStreams() throws IOException {
        if (Util.debugMode) {
            this.dbis = new DebugInputStream(this.socket.getInputStream());
            this.pbis = new PushbackInputStream(this.dbis);
            this.dos = new DataOutputStream(new DebugOutputStream(this.socket.getOutputStream()));
        } else {
            this.pbis = new PushbackInputStream(this.socket.getInputStream());
            this.dos = new DataOutputStream(this.socket.getOutputStream());
        }
    }

    String readLine() throws IOException {
        String s = "";
        if (this.eof) {
            return null;
        }
        int c = this.pbis.read();
        if (c == 255 || c < 0) {
            this.eof = true;
            return null;
        }
        while (c != 255 && c >= 0 && c != 10 && c != 13) {
            s = s + (char)c;
            c = this.pbis.read();
        }
        if (c == 255 || c < 0) {
            this.eof = true;
        } else {
            int c2 = this.pbis.read();
            if (c == 10 && c2 != 13 || c == 13 && c2 != 10) {
                this.pbis.unread(c2);
            }
        }
        return s;
    }

    int read(byte[] b, int off, int len) throws IOException {
        return this.pbis.read(b, off, len);
    }

    int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    void println(String s) throws IOException {
        this.dos.writeBytes(s + this.lineEnd);
    }

    void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    void writeUShort(int i) throws IOException {
        this.dos.writeShort(i & 0xFFFF);
    }

    void writeUInt(long l) throws IOException {
        this.dos.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    void flush() throws IOException {
        this.dos.flush();
    }

    void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.sectionEnd();
    }

    void sectionEnd() {
        if (this.dbis != null) {
            this.dbis.debugDump();
        }
    }

    private boolean doNotProxy(String s) {
        s = s.toLowerCase();
        String p = System.getProperty("http.nonProxyHosts", "");
        StringTokenizer st = new StringTokenizer(p, "|");
        while (st.hasMoreTokens()) {
            p = st.nextToken();
            if (!(p.startsWith("*") ? s.endsWith((p = p.substring(1)).toLowerCase()) : s.equalsIgnoreCase(p))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.me;
    }
}

