/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class SelectChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;
    private SelectorManager _manager = new SelectorManager(){

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
            if (channel == null) {
                return null;
            }
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SelectChannelConnector.this.configure(socket);
            return channel;
        }

        protected boolean dispatch(Runnable task) throws IOException {
            return SelectChannelConnector.this.getThreadPool().dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionClosed((HttpConnection)endpoint.getConnection());
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened((HttpConnection)endpoint.getConnection());
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return new HttpConnection(SelectChannelConnector.this, endpoint, SelectChannelConnector.this.getServer());
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    };

    public void accept(int acceptorID) throws IOException {
        this._manager.doSelect(acceptorID);
    }

    public void stopAccept(int acceptorID) throws Exception {
        this._manager.doStop(acceptorID);
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
    }

    public Object getConnection() {
        return this._acceptChannel;
    }

    public boolean getDelaySelectKeyUpdate() {
        return this._manager.isDelaySelectKeyUpdate();
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = ServerSocketChannel.open();
            this._acceptChannel.configureBlocking(false);
            InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
            this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
            this._manager.register(this._acceptChannel, 16);
        }
    }

    public void setDelaySelectKeyUpdate(boolean delay) {
        this._manager.setDelaySelectKeyUpdate(delay);
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime(maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._manager.stop();
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new ConnectorEndPoint(channel, selectSet, key);
    }

    public static class RetryContinuation
    extends Timeout.Task
    implements Continuation,
    Runnable {
        SelectChannelEndPoint _endPoint = (SelectChannelEndPoint)HttpConnection.getCurrentConnection().getEndPoint();
        boolean _new = true;
        Object _object;
        boolean _pending = false;
        boolean _resumed = false;
        RetryRequest _retry;
        boolean _scheduled = false;
        long _timeout;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                redispatch = this._scheduled && this._pending && !this._resumed;
            }
            if (redispatch) {
                this._endPoint.getSelectSet().addChange(this);
                this._endPoint.getSelectSet().wakeup();
            }
        }

        public Object getObject() {
            return this._object;
        }

        public long getTimeout() {
            return this._timeout;
        }

        public boolean isNew() {
            return this._new;
        }

        public boolean isPending() {
            return this._pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this;
            synchronized (object) {
                this._resumed = false;
                this._pending = false;
                this._scheduled = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (this._pending && !this.isExpired()) {
                    this._resumed = true;
                    redispatch = this._scheduled;
                }
            }
            if (redispatch) {
                SelectorManager.SelectSet selectSet;
                SelectorManager.SelectSet selectSet2 = selectSet = this._endPoint.getSelectSet();
                synchronized (selectSet2) {
                    this.cancel();
                }
                selectSet.addChange(this);
                selectSet.wakeup();
            }
        }

        public void run() {
            this._endPoint.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean schedule() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (!this._pending) {
                    return false;
                }
                this._scheduled = true;
                redispatch = this.isExpired() || this._resumed;
            }
            if (redispatch) {
                this._endPoint.getSelectSet().addChange(this);
            } else {
                this._endPoint.getSelectSet().scheduleTimeout(this, this._timeout);
            }
            this._endPoint.getSelectSet().wakeup();
            return true;
        }

        public void setObject(Object object) {
            this._object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend(long timeout) {
            boolean resumed = false;
            Object object = this;
            synchronized (object) {
                resumed = this._resumed;
                this._resumed = false;
                this._new = false;
                if (!this._pending && !resumed && timeout >= 0L) {
                    this._pending = true;
                    this._scheduled = false;
                    this._timeout = timeout;
                    if (this._retry == null) {
                        this._retry = new RetryRequest();
                    }
                    throw this._retry;
                }
                this._resumed = false;
                this._pending = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
            return resumed;
        }
    }

    public static class ConnectorEndPoint
    extends SelectChannelEndPoint {
        public ConnectorEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) {
            super(channel, selectSet, key);
            this.scheduleIdle();
        }

        public void close() throws IOException {
            RetryContinuation continuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation();
            if (continuation != null && continuation.isPending()) {
                continuation.reset();
            }
            super.close();
        }

        public boolean dispatch(boolean assumeShortDispatch) throws IOException {
            this.cancelIdle();
            return super.dispatch(assumeShortDispatch);
        }

        public void undispatch() {
            RetryContinuation continuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation();
            if (continuation != null) {
                Log.debug((String)"continuation {}", (Object)continuation);
                if (!continuation.schedule()) {
                    super.undispatch();
                }
            } else {
                super.undispatch();
                if (this._connection.isIdle()) {
                    this.scheduleIdle();
                }
            }
        }
    }
}

