/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.utils.GrowingByteArray;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class EncodedLoggingEvent
extends LoggingEvent {
    private static final long serialVersionUID = 7853305442598838656L;
    private final LoggingEvent event;
    private final int maxMessageSize;
    private static final int LOG_SIZE = 1024;
    private static final ThreadLocal<LoggingEventCacheEntry> cachedLoggingEvent = new ThreadLocal();
    private static final ThreadLocal<GrowingByteArray> tlStringBuffers = new ThreadLocal<GrowingByteArray>(){

        @Override
        protected synchronized GrowingByteArray initialValue() {
            return new GrowingByteArray(1024);
        }
    };
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public EncodedLoggingEvent(LoggingEvent event, int maxMessageSize) {
        super(null, (Category)Logger.getLogger((String)event.getLoggerName()), null, null, null);
        this.event = event;
        this.maxMessageSize = maxMessageSize;
    }

    public Level getLevel() {
        return this.event.getLevel();
    }

    public LocationInfo getLocationInformation() {
        return this.event.getLocationInformation();
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public Object getMDC(String key) {
        return this.event.getMDC(key);
    }

    public void getMDCCopy() {
        this.event.getMDCCopy();
    }

    public Object getMessage() {
        return this.event.getMessage();
    }

    public String getNDC() {
        return this.event.getNDC();
    }

    public String getRenderedMessage() {
        String string = this.event.getRenderedMessage();
        String[] throwableStrRep = this.event.getThrowableStrRep();
        if (throwableStrRep != null) {
            for (int i = 0; i < throwableStrRep.length; ++i) {
                string = string + "\n";
                string = string + throwableStrRep[i];
            }
        }
        try {
            byte[] chars = string.getBytes("UTF-8");
            int length = this.maxMessageSize == 0 || chars.length < this.maxMessageSize ? chars.length : this.maxMessageSize;
            LoggingEventCacheEntry encodingCacheEntry = cachedLoggingEvent.get();
            if (encodingCacheEntry == null || length != encodingCacheEntry.getMaxSize() || string != encodingCacheEntry.getInputMessage()) {
                GrowingByteArray out = tlStringBuffers.get();
                out.reset();
                for (int i = 0; i < length; ++i) {
                    byte ch = chars[i];
                    if (ch == 92) {
                        out.add((byte)92).add((byte)92);
                        continue;
                    }
                    if (ch == 13) {
                        out.add((byte)92).add((byte)114);
                        continue;
                    }
                    if (ch == 10) {
                        out.add((byte)92).add((byte)110);
                        continue;
                    }
                    if (ch == 9) {
                        out.add((byte)92).add((byte)116);
                        continue;
                    }
                    if (ch == 47) {
                        out.add((byte)92).add((byte)115);
                        continue;
                    }
                    if (ch > 126 || ch < 32) {
                        out.add((byte)92).add((byte)35).add(EncodedLoggingEvent.getHexRepresentation(ch));
                        continue;
                    }
                    out.add(ch);
                }
                encodingCacheEntry = new LoggingEventCacheEntry(string, length, out.toString());
                cachedLoggingEvent.set(encodingCacheEntry);
            }
            return encodingCacheEntry.getEncodedMessage();
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static byte[] getHexRepresentation(byte raw) {
        byte[] hex = new byte[2];
        int v = raw & 0xFF;
        hex[0] = HEX_CHAR_TABLE[v >>> 4];
        hex[1] = HEX_CHAR_TABLE[v & 0xF];
        return hex;
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public ThrowableInformation getThrowableInformation() {
        return null;
    }

    public String[] getThrowableStrRep() {
        return null;
    }

    class LoggingEventCacheEntry {
        private final String inputMessage;
        private final int maxSize;
        private final String encodedMessage;

        public LoggingEventCacheEntry(String inputMessage, int maxSize, String encodedMessage) {
            this.inputMessage = inputMessage;
            this.maxSize = maxSize;
            this.encodedMessage = encodedMessage;
        }

        public String getInputMessage() {
            return this.inputMessage;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public String getEncodedMessage() {
            return this.encodedMessage;
        }
    }
}

