/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.util.logging.Logger;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractStateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.Connector;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ControllerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StreamInfoProvider;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TimeoutableController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.LocallyCancelledInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SocketStreamInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SuccessfulStateInfo;

public abstract class AbstractConnectionController
extends AbstractStateController
implements StreamInfoProvider,
TimeoutableController {
    private static final Logger LOGGER = Logger.getLogger(AbstractConnectionController.class.getName());
    private SocketStreamInfo stream;
    private RvConnection rvConnection;
    private Thread thread = null;
    private boolean connected = false;
    private Connector connector = null;

    public AbstractConnectionController() {
        this.addControllerListener(new ControllerListener(){

            public void handleControllerSucceeded(StateController controller, SuccessfulStateInfo info) {
            }

            public void handleControllerFailed(StateController controller, FailedStateInfo info) {
                if (AbstractConnectionController.this.thread != null) {
                    AbstractConnectionController.this.thread.interrupt();
                }
            }
        });
    }

    public StreamInfo getStreamInfo() {
        return this.stream;
    }

    public RvConnection getRvConnection() {
        return this.rvConnection;
    }

    public RvSessionConnectionInfo getRvSessionInfo() {
        return this.rvConnection.getRvSessionInfo();
    }

    protected synchronized void stopConnectionTimer() {
        this.connected = true;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void start(RvConnection transfer, StateController last) {
        DefensiveTools.checkNull((Object)transfer, (String)"transfer");
        StateInfo endState = this.getEndStateInfo();
        if (endState != null) {
            throw new IllegalStateException("state is alreaday " + endState);
        }
        this.rvConnection = transfer;
        try {
            this.connector.checkConnectionInfo();
            this.initializeBeforeStarting();
        }
        catch (Exception e) {
            this.fireFailed(e);
            return;
        }
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    AbstractConnectionController.this.openConnectionInThread();
                }
                catch (Exception e) {
                    AbstractConnectionController.this.fireFailed(e);
                }
            }
        }, "RV connector: " + this);
        this.thread.start();
    }

    public void cancelIfNotFruitful(long timeout) {
        if (!this.isConnected()) {
            this.fireFailed(new ConnectionTimedOutEvent(timeout));
        }
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.fireFailed(new LocallyCancelledInfo());
    }

    protected void initializeBeforeStarting() throws IOException {
    }

    protected void openConnectionInThread() {
        try {
            LOGGER.fine(this + " opening socket");
            this.prepareStream();
            this.getRvConnection().getTimeoutHandler().startTimeout(this);
            this.stream = this.createStream();
            LOGGER.fine(this + " initializing connection in thread");
            this.initializeConnectionInThread();
        }
        catch (Exception e) {
            this.fireFailed(e);
        }
    }

    protected void prepareStream() throws IOException {
        this.connector.prepareStream();
    }

    protected SocketStreamInfo createStream() throws IOException {
        return this.connector.createStream();
    }

    protected abstract void handleConnectingState();

    protected abstract void handleResolvingState();

    protected void fireConnected() {
        this.fireSucceeded(this.stream);
    }

    protected void initializeConnectionInThread() throws IOException, FailureEventException {
        this.fireConnected();
    }
}

