/*
 * Decompiled with CFR 0.152.
 */
package com.sun.stun;

import com.sun.stun.StunHeader;
import com.sun.stun.StunServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StunServerImpl
implements StunServer {
    private static final Logger logger = Logger.getLogger(StunServerImpl.class.getName());
    private DatagramSocket socket;
    private static int stunServerPort = 3478;

    public void startServer() throws IOException {
        new StunUdpListener(stunServerPort);
        new StunUdpListener(stunServerPort + 1);
        new StunTcpListener(stunServerPort);
        new StunTcpListener(stunServerPort + 1);
    }

    public static void setLogLevel(Level newLevel) {
        logger.setLevel(newLevel);
    }

    public void processStunRequest(DatagramChannel channel, InetSocketAddress isa, byte[] request) {
        int changeRequest;
        logger.warning("Got UDP Stun request for channel " + request.length + " bytes from " + isa);
        byte[] response = this.getStunResponse(isa, request, request.length);
        InetSocketAddress responseAddress = StunHeader.getAddress(request, 2);
        if (responseAddress != null) {
            isa = new InetSocketAddress(responseAddress.getAddress(), responseAddress.getPort());
        }
        if (((changeRequest = StunHeader.getChangeRequest(request)) & 4) != 0) {
            return;
        }
        if ((changeRequest & 2) == 0) {
            try {
                channel.send(ByteBuffer.wrap(response), isa);
            }
            catch (IOException ee) {
                logger.warning("Can't send Binding Error response on channel: " + ee.getMessage());
            }
            return;
        }
        DatagramSocket responseSocket = null;
        String s = null;
        try {
            responseSocket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(response, response.length, isa);
            responseSocket.send(packet);
            return;
        }
        catch (SocketException e) {
            s = "CHANGE_PORT set but can't create new socket! " + e.getMessage();
        }
        catch (IOException e) {
            s = "Can't send Binding Response on socket:  " + e.getMessage();
        }
        logger.warning(s);
        response = this.getBindingErrorResponse(request, 600, s);
        try {
            channel.send(ByteBuffer.wrap(response), isa);
        }
        catch (IOException e) {
            logger.warning("Can't send Binding Error response on channel: " + e.getMessage());
            return;
        }
    }

    @Override
    public void processStunRequest(DatagramSocket socket, DatagramPacket packet) {
        int changeRequest;
        byte[] request = packet.getData();
        int length = packet.getLength();
        InetSocketAddress isa = (InetSocketAddress)packet.getSocketAddress();
        logger.fine("Got UDP Stun request on socket " + socket.getLocalAddress() + ":" + socket.getLocalPort() + " length " + length + " bytes " + " from " + isa);
        byte[] response = this.getStunResponse(isa, request, length);
        InetSocketAddress responseAddress = StunHeader.getAddress(request, 2);
        if (responseAddress != null) {
            packet.setAddress(responseAddress.getAddress());
            packet.setPort(responseAddress.getPort());
        }
        if (((changeRequest = StunHeader.getChangeRequest(request)) & 4) != 0) {
            return;
        }
        DatagramSocket responseSocket = socket;
        if ((changeRequest & 2) != 0) {
            try {
                responseSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                String s = "CHANGE_PORT set but can't create new socket! " + e.getMessage();
                logger.warning(s);
                response = this.getBindingErrorResponse(request, 600, s);
            }
        }
        packet.setData(response);
        try {
            responseSocket.send(packet);
            String s = "";
            if (request.length >= 32) {
                int port = request[26] << 8 & 0xFF00 | request[27] & 0xFF;
                String privateAddress = " private address " + (request[28] & 0xFF) + "." + (request[29] & 0xFF) + "." + (request[30] & 0xFF) + "." + (request[31] & 0xFF);
                s = privateAddress + ":" + port;
            }
            logger.warning("Sent STUN Binding Response from " + responseSocket.getLocalAddress() + ":" + responseSocket.getLocalPort() + " to " + packet.getAddress() + ":" + packet.getPort() + s);
        }
        catch (IOException e) {
            logger.warning("Unable to send STUN response! " + e.getMessage());
        }
    }

    public void processStunRequest(Socket socket) {
        logger.finer("Got TCP Stun request from " + socket.getInetAddress() + ":" + socket.getPort());
        try {
            DataInputStream input = new DataInputStream(socket.getInputStream());
            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
            InetSocketAddress isa = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
            byte[] request = new byte[1000];
            int length = input.read(request);
            if (length == -1) {
                logger.info("Stunserver socket closed to " + isa);
                return;
            }
            byte[] response = this.getStunResponse(isa, request, length);
            output.write(response);
            logger.finer("Sent TCP STUN Binding Response to " + isa);
        }
        catch (IOException e) {
            logger.warning("Unable to send TCP STUN response! " + e.getMessage());
        }
    }

    private byte[] getStunResponse(InetSocketAddress isa, byte[] request, int length) {
        if (length < 20) {
            String msg = "Too short to have STUN HEADER " + length;
            logger.warning(msg);
            return this.getBindingErrorResponse(request, 400, msg);
        }
        int messageType = request[0] << 8 & 0xFF00 | request[1] & 0xFF;
        if (messageType != 1) {
            String msg = "Only Binding Request is supported";
            return this.getBindingErrorResponse(request, 600, msg);
        }
        return this.processBindingRequest(isa, request, length);
    }

    private byte[] processBindingRequest(InetSocketAddress isa, byte[] request, int length) {
        byte[] response = new byte[44];
        System.arraycopy(request, 0, response, 0, 20);
        response[0] = 1;
        response[3] = 24;
        response[21] = 1;
        response[23] = 8;
        response[25] = 1;
        logger.fine("responding with " + isa);
        int sourcePort = isa.getPort();
        response[26] = (byte)(sourcePort >> 8);
        response[27] = (byte)(sourcePort & 0xFF);
        byte[] sourceAddress = isa.getAddress().getAddress();
        response[28] = sourceAddress[0];
        response[29] = sourceAddress[1];
        response[30] = sourceAddress[2];
        response[31] = sourceAddress[3];
        response[33] = 5;
        response[35] = 8;
        response[37] = 1;
        response[38] = (byte)(sourcePort >> 8);
        response[39] = (byte)(sourcePort & 0xFF);
        response[40] = sourceAddress[0];
        response[41] = sourceAddress[1];
        response[42] = sourceAddress[2];
        response[43] = sourceAddress[3];
        return response;
    }

    private byte[] getBindingErrorResponse(byte[] request, int responseCode, String reason) {
        byte[] response = new byte[24 + reason.length()];
        System.arraycopy(request, 0, response, 0, 20);
        response[0] = 1;
        response[1] = 17;
        response[22] = (byte)(responseCode >> 8);
        response[23] = (byte)(responseCode & 0xFF);
        byte[] reasonBytes = reason.getBytes();
        System.arraycopy(reasonBytes, 0, response, 24, reasonBytes.length);
        int length = 24 + reasonBytes.length;
        response[2] = (byte)(length >> 8);
        response[3] = (byte)(length & 0xFF);
        return response;
    }

    public static void main(String[] args) {
        StunServerImpl stunServerImpl = new StunServerImpl();
        try {
            stunServerImpl.startServer();
        }
        catch (IOException e) {
            System.out.println("IOException:  " + e.getMessage());
            System.exit(1);
        }
        stunServerImpl.test();
    }

    private void test() {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
        }
        catch (SocketException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        byte[] request = new byte[20];
        request[1] = 1;
        for (int i = 0; i < 16; ++i) {
            request[4 + i] = (byte)i;
        }
        DatagramPacket packet = null;
        try {
            packet = new DatagramPacket(request, request.length, InetAddress.getLocalHost(), stunServerPort);
        }
        catch (UnknownHostException e) {
            System.out.println("Can't get LocalHost!");
            System.exit(1);
        }
        try {
            socket.send(packet);
            if (logger.isLoggable(Level.FINEST)) {
                StunHeader.dump("Sent STUN Binding Request to " + packet.getAddress() + ":" + packet.getPort(), request, 0, request.length);
            }
        }
        catch (IOException e) {
            System.out.println("Unable to send STUN Binding Request! " + e.getMessage());
        }
    }

    static {
        String s = System.getProperty("gov.nist.javax.sip.stack.STUN_SERVER_PORT");
        if (s != null) {
            try {
                stunServerPort = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid stun server port " + s + " defaulting to " + stunServerPort);
            }
        }
    }

    class StunTcpListener
    extends Thread {
        private ServerSocket serverSocket;
        private int stunServerPort;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StunTcpListener(int stunServerPort) throws IOException {
            try {
                this.serverSocket = new ServerSocket(stunServerPort);
            }
            catch (SocketException e) {
                throw new IOException("Can't create ServerSocket:  " + e.getMessage());
            }
            this.stunServerPort = stunServerPort;
            StunTcpListener stunTcpListener = this;
            synchronized (stunTcpListener) {
                this.start();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.fine("STUN Server:  Listening for Stun requests on TCP port " + this.stunServerPort + "...");
            StunTcpListener stunTcpListener = this;
            synchronized (stunTcpListener) {
                this.notifyAll();
            }
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        InetAddress address = socket.getInetAddress();
                        logger.info("New TCP STUN connection accepted from " + address.getHostAddress() + ":" + socket.getPort());
                        StunServerImpl.this.processStunRequest(socket);
                    }
                }
                catch (IOException e) {
                    logger.warning("STUN Server:  send or received failed " + e.toString());
                    continue;
                }
                break;
            }
        }
    }

    class StunUdpListener
    extends Thread {
        private DatagramSocket socket;
        private int stunServerPort;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StunUdpListener(int stunServerPort) throws IOException {
            try {
                this.socket = new DatagramSocket(stunServerPort);
            }
            catch (SocketException e) {
                throw new IOException("Can't create DatagramSocket:  " + e.getMessage());
            }
            this.stunServerPort = stunServerPort;
            StunUdpListener stunUdpListener = this;
            synchronized (stunUdpListener) {
                this.start();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.fine("STUN Server:  Listening for Stun requests on UDP port " + this.stunServerPort + "...");
            StunUdpListener stunUdpListener = this;
            synchronized (stunUdpListener) {
                this.notifyAll();
            }
            while (true) {
                try {
                    while (true) {
                        byte[] buf = new byte[10000];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        this.socket.receive(packet);
                        StunServerImpl.this.processStunRequest(this.socket, packet);
                    }
                }
                catch (IOException e) {
                    logger.warning("STUN Server:  send or received failed " + e.toString());
                    continue;
                }
                break;
            }
        }
    }
}

