/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import net.sf.jml.exception.JmlException;
import net.sf.jml.util.DigestUtils;
import net.sf.jml.util.StringUtils;

public final class MsnObject {
    public static final int TYPE_CUSTOM_EMOTICON = 2;
    public static final int TYPE_DISPLAY_PICTURE = 3;
    public static final int TYPE_BACKGROUND = 5;
    public static final int TYPE_WINKS = 8;
    private String creator;
    private int type = 3;
    private String location = "joy.tmp";
    private String friendly = "AAA=";
    private String sha1d;
    private String sha1c;
    private byte[] msnObj;

    public static final MsnObject getInstance(String string, byte[] byArray) throws JmlException {
        if (string == null) {
            throw new JmlException("Creator can't null!");
        }
        if (byArray == null) {
            throw new JmlException("Picture can't null!");
        }
        return new MsnObject(string, byArray);
    }

    public static final MsnObject getInstance(String string, String string2) throws JmlException {
        byte[] byArray;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JmlException("File " + string2 + " not found!", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new JmlException("File " + string2 + " can't access!", iOException);
        }
        return MsnObject.getInstance(string, byArray);
    }

    private MsnObject(String string, byte[] byArray) {
        this.creator = string;
        this.msnObj = byArray;
        this.generate();
    }

    private void generate() {
        this.sha1d = StringUtils.encodeBase64(DigestUtils.sha1(this.msnObj));
        String string = "Creator" + this.getCreator() + "Size" + this.msnObj.length + "Type" + this.getType() + "Location" + this.getLocation() + "Friendly" + this.getFriendly() + "SHA1D" + this.sha1d;
        this.sha1c = StringUtils.encodeBase64(DigestUtils.sha1(string.getBytes()));
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
        this.generate();
    }

    public int getSize() {
        return this.msnObj.length;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.generate();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
        this.generate();
    }

    public String getFriendly() {
        return this.friendly;
    }

    public void setFriendly(String string) {
        if (string == null) {
            return;
        }
        try {
            string = StringUtils.encodeBase64(string.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = StringUtils.encodeBase64(string.getBytes());
        }
        this.friendly = string;
        this.generate();
    }

    public String getSha1d() {
        return this.sha1d;
    }

    public String getSha1c() {
        return this.sha1c;
    }

    public byte[] getMsnObj() {
        return this.msnObj;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<msnobj Creator=");
        stringBuffer.append("\"" + this.getCreator() + "\"");
        stringBuffer.append(" Size=");
        stringBuffer.append("\"" + this.getSize() + "\"");
        stringBuffer.append(" Type=");
        stringBuffer.append("\"" + this.getType() + "\"");
        stringBuffer.append(" Location=");
        stringBuffer.append("\"" + this.getLocation() + "\"");
        stringBuffer.append(" Friendly=");
        stringBuffer.append("\"" + this.getFriendly() + "\"");
        stringBuffer.append(" SHA1D=");
        stringBuffer.append("\"" + this.getSha1d() + "\"");
        stringBuffer.append(" SHA1C=");
        stringBuffer.append("\"" + this.getSha1c() + "\"");
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this.getSha1c() == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof MsnObject) {
            return this.getSha1c().equals(((MsnObject)object).getSha1c());
        }
        return false;
    }

    public static void main(String[] stringArray) {
    }
}

