/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlockHolder;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class EncryptionInfoAck
extends ConnCommand {
    private final ExtraInfoBlockHolder[] blocks;

    protected EncryptionInfoAck(SnacPacket snacPacket) {
        super(35);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.blocks = ExtraInfoBlockHolder.readBlockHolders(byteBlock);
    }

    public EncryptionInfoAck(ExtraInfoBlockHolder[] extraInfoBlockHolderArray) {
        super(35);
        DefensiveTools.checkNull(extraInfoBlockHolderArray, "blocks");
        this.blocks = (ExtraInfoBlockHolder[])DefensiveTools.getNonnullArray(extraInfoBlockHolderArray, "blocks");
    }

    public final ExtraInfoBlockHolder[] getExtraInfoBlocks() {
        return (ExtraInfoBlockHolder[])this.blocks.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(outputStream);
        }
    }

    public String toString() {
        return "EncryptionInfoAck: blocks=" + Arrays.asList(this.blocks);
    }
}

