/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class InfoData
implements LiveWritable {
    public static final String NOT_AWAY = "";
    private static final int TYPE_INFO_FMT = 1;
    private static final int TYPE_INFO = 2;
    private static final int TYPE_AWAY_FMT = 3;
    private static final int TYPE_AWAY = 4;
    private static final int TYPE_CAPS = 5;
    private static final int TYPE_CERTIFICATE_INFO = 6;
    private final String info;
    private final String awayMessage;
    private final CapabilityBlock[] caps;
    private final CertificateInfo certInfo;

    public static InfoData readInfoData(ByteBlock byteBlock) {
        return InfoData.readInfoDataFromChain(TlvTools.readChain(byteBlock));
    }

    public static InfoData readInfoDataFromChain(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        String string = tlvChain.getString(3);
        Tlv tlv = tlvChain.getLastTlv(4);
        String string2 = tlvChain.getString(1);
        Tlv tlv2 = tlvChain.getLastTlv(2);
        Tlv tlv3 = tlvChain.getLastTlv(5);
        Tlv tlv4 = tlvChain.getLastTlv(6);
        String string3 = null;
        if (tlv != null) {
            string3 = OscarTools.getInfoString(tlv.getData(), string);
        }
        String string4 = null;
        if (tlv2 != null) {
            string4 = OscarTools.getInfoString(tlv2.getData(), string2);
        }
        CapabilityBlock[] capabilityBlockArray = null;
        if (tlv3 != null) {
            capabilityBlockArray = CapabilityBlock.getCapabilityBlocks(tlv3.getData());
        }
        CertificateInfo certificateInfo = null;
        if (tlv4 != null) {
            certificateInfo = CertificateInfo.readCertInfoBlock(tlv4.getData());
        }
        return new InfoData(string4, string3, capabilityBlockArray, certificateInfo);
    }

    public InfoData(String string) {
        this(null, string, null, null);
    }

    public InfoData(String string, String string2, CapabilityBlock[] capabilityBlockArray, CertificateInfo certificateInfo) {
        this.info = string;
        this.awayMessage = string2;
        this.caps = (CapabilityBlock[])DefensiveTools.getNonnullArray(capabilityBlockArray, "caps");
        this.certInfo = certificateInfo;
    }

    public final String getInfo() {
        return this.info;
    }

    public final String getAwayMessage() {
        return this.awayMessage;
    }

    public final CapabilityBlock[] getCaps() {
        return (CapabilityBlock[])(this.caps == null ? null : this.caps.clone());
    }

    public final CertificateInfo getCertificateInfo() {
        return this.certInfo;
    }

    private static String getFormatString(String string) {
        return "text/x-aolrtf; charset=" + string;
    }

    private static void writeInfoTlvs(String string, OutputStream outputStream, int n, int n2) throws IOException {
        EncodedStringInfo encodedStringInfo = MinimalEncoder.encodeMinimally(string);
        ByteBlock byteBlock = ByteBlock.wrap(encodedStringInfo.getData());
        String string2 = InfoData.getFormatString(encodedStringInfo.getCharset());
        Tlv.getStringInstance(n, string2).write(outputStream);
        new Tlv(n2, byteBlock).write(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        if (this.info != null) {
            InfoData.writeInfoTlvs(this.info, outputStream, 1, 2);
        }
        if (this.awayMessage != null) {
            InfoData.writeInfoTlvs(this.awayMessage, outputStream, 3, 4);
        }
        if (this.caps != null) {
            object = CapabilityBlock.convertToBytes(this.caps);
            new Tlv(5, ByteBlock.wrap(object)).write(outputStream);
        }
        if (this.certInfo != null) {
            object = ByteBlock.createByteBlock(this.certInfo);
            new Tlv(6, (Writable)object).write(outputStream);
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InfoData:");
        if (this.info != null && this.info.length() > 0) {
            string = this.info;
            if (string.length() > 20) {
                string = string.substring(0, 20) + "...";
            }
            stringBuffer.append("  info: ");
            stringBuffer.append(string);
        }
        if (this.awayMessage != null && this.awayMessage.length() > 0) {
            string = this.awayMessage;
            if (string.length() > 20) {
                string = string.substring(0, 20) + "...";
            }
            stringBuffer.append("  away: ");
            stringBuffer.append(string);
        }
        if (this.caps != null && this.caps.length > 0) {
            stringBuffer.append("  capabilities: ");
            stringBuffer.append(this.caps.length);
        }
        if (this.certInfo != null) {
            stringBuffer.append("  certinfo: ");
            stringBuffer.append(this.certInfo);
        }
        return stringBuffer.toString();
    }
}

