/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tar
extends MatchingTask {
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    File tarFile;
    File baseDir;
    private TarLongFileMode longFileMode;
    Vector filesets;
    Vector fileSetFiles;
    private boolean longWarningGiven;
    private TarCompressionMethod compression;

    public TarFileSet createTarFileSet() {
        TarFileSet tarFileSet = new TarFileSet();
        this.filesets.addElement(tarFileSet);
        return tarFileSet;
    }

    public void setTarfile(File file) {
        this.tarFile = file;
    }

    public void setDestFile(File file) {
        this.tarFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setLongfile(String string) {
        this.log("DEPRECATED - The setLongfile(String) method has been deprecated. Use setLongfile(Tar.TarLongFileMode) instead.");
        this.longFileMode = new TarLongFileMode();
        this.longFileMode.setValue(string);
    }

    public void setLongfile(TarLongFileMode tarLongFileMode) {
        this.longFileMode = tarLongFileMode;
    }

    public void setCompression(TarCompressionMethod tarCompressionMethod) {
        this.compression = tarCompressionMethod;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.getLocation());
        }
        if (this.tarFile.exists() && this.tarFile.isDirectory()) {
            throw new BuildException("tarfile is a directory!", this.getLocation());
        }
        if (this.tarFile.exists() && !this.tarFile.canWrite()) {
            throw new BuildException("Can not write to the specified tarfile!", this.getLocation());
        }
        Vector vector = (Vector)this.filesets.clone();
        try {
            String[] stringArray;
            if (this.baseDir != null) {
                if (!this.baseDir.exists()) {
                    throw new BuildException("basedir does not exist!", this.getLocation());
                }
                TarFileSet tarFileSet = new TarFileSet(this.fileset);
                tarFileSet.setDir(this.baseDir);
                this.filesets.addElement(tarFileSet);
            }
            if (this.filesets.size() == 0) {
                throw new BuildException("You must supply either a basedir attribute or some nested filesets.", this.getLocation());
            }
            boolean bl = true;
            Object object = this.filesets.elements();
            block11: while (true) {
                if (!object.hasMoreElements()) {
                    if (!bl) break;
                    this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                    Object var3_9 = null;
                    this.filesets = vector;
                    return;
                }
                TarFileSet tarFileSet = (TarFileSet)object.nextElement();
                stringArray = tarFileSet.getFiles(this.getProject());
                if (!this.archiveIsUpToDate(stringArray, tarFileSet.getDir(this.getProject()))) {
                    bl = false;
                }
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) continue block11;
                    if (this.tarFile.equals(new File(tarFileSet.getDir(this.getProject()), stringArray[n]))) {
                        throw new BuildException("A tar file cannot include itself", this.getLocation());
                    }
                    ++n;
                }
                break;
            }
            this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
            object = null;
            try {
                try {
                    object = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
                    ((TarOutputStream)object).setDebug(true);
                    if (this.longFileMode.isTruncateMode()) {
                        ((TarOutputStream)object).setLongFileMode(1);
                    } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                        ((TarOutputStream)object).setLongFileMode(0);
                    } else {
                        ((TarOutputStream)object).setLongFileMode(2);
                    }
                    this.longWarningGiven = false;
                    Enumeration enumeration = this.filesets.elements();
                    while (enumeration.hasMoreElements()) {
                        TarFileSet tarFileSet = (TarFileSet)enumeration.nextElement();
                        String[] stringArray2 = tarFileSet.getFiles(this.getProject());
                        if (stringArray2.length > 1 && tarFileSet.getFullpath().length() > 0) {
                            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
                        }
                        int n = 0;
                        while (n < stringArray2.length) {
                            File file = new File(tarFileSet.getDir(this.getProject()), stringArray2[n]);
                            String string = stringArray2[n].replace(File.separatorChar, '/');
                            this.tarFile(file, (TarOutputStream)object, string, tarFileSet);
                            ++n;
                        }
                    }
                }
                catch (IOException iOException) {
                    String string = "Problem creating TAR: " + iOException.getMessage();
                    throw new BuildException(string, iOException, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                stringArray = null;
                if (object == null) throw throwable;
                try {
                    ((TarOutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                stringArray = null;
                if (object != null) {
                    try {}
                    catch (IOException iOException) {}
                    ((TarOutputStream)object).close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.filesets = vector;
            throw throwable;
        }
        {
            Object var3_11 = null;
            this.filesets = vector;
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void tarFile(File var1_1, TarOutputStream var2_2, String var3_3, TarFileSet var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 515->519)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean archiveIsUpToDate(String[] stringArray) {
        return this.archiveIsUpToDate(stringArray, this.baseDir);
    }

    protected boolean archiveIsUpToDate(String[] stringArray, File file) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(this.tarFile.getAbsolutePath());
        boolean bl = false;
        if (sourceFileScanner.restrict(stringArray, file, null, mergingMapper).length == 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.longFileMode = new TarLongFileMode();
        this.filesets = new Vector();
        this.fileSetFiles = new Vector();
        this.longWarningGiven = false;
        this.compression = new TarCompressionMethod();
    }

    public Tar() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TarFileSet
    extends FileSet {
        private String[] files;
        private int fileMode;
        private int dirMode;
        private String userName;
        private String groupName;
        private int uid;
        private int gid;
        private String prefix;
        private String fullpath;
        private boolean preserveLeadingSlashes;

        public String[] getFiles(Project project) {
            if (this.files == null) {
                DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
                String[] stringArray = directoryScanner.getIncludedDirectories();
                String[] stringArray2 = directoryScanner.getIncludedFiles();
                this.files = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray, 0, this.files, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, this.files, stringArray.length, stringArray2.length);
            }
            return this.files;
        }

        public void setMode(String string) {
            this.fileMode = 0x8000 | Integer.parseInt(string, 8);
        }

        public int getMode() {
            return this.fileMode;
        }

        public void setDirMode(String string) {
            this.dirMode = 0x4000 | Integer.parseInt(string, 8);
        }

        public int getDirMode() {
            return this.dirMode;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUid(int n) {
            this.uid = n;
        }

        public int getUid() {
            return this.uid;
        }

        public void setGroup(String string) {
            this.groupName = string;
        }

        public String getGroup() {
            return this.groupName;
        }

        public void setGid(int n) {
            this.gid = n;
        }

        public int getGid() {
            return this.gid;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setFullpath(String string) {
            this.fullpath = string;
        }

        public String getFullpath() {
            return this.fullpath;
        }

        public void setPreserveLeadingSlashes(boolean bl) {
            this.preserveLeadingSlashes = bl;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }

        private final /* synthetic */ void this() {
            this.files = null;
            this.fileMode = 33188;
            this.dirMode = 16877;
            this.userName = "";
            this.groupName = "";
            this.prefix = "";
            this.fullpath = "";
            this.preserveLeadingSlashes = false;
        }

        public TarFileSet(FileSet fileSet) {
            super(fileSet);
            this.this();
        }

        public TarFileSet() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TarLongFileMode
    extends EnumeratedAttribute {
        public static final String WARN = "warn";
        public static final String FAIL = "fail";
        public static final String TRUNCATE = "truncate";
        public static final String GNU = "gnu";
        public static final String OMIT = "omit";
        private final String[] validModes;

        public String[] getValues() {
            return this.validModes;
        }

        public boolean isTruncateMode() {
            return "truncate".equalsIgnoreCase(this.getValue());
        }

        public boolean isWarnMode() {
            return "warn".equalsIgnoreCase(this.getValue());
        }

        public boolean isGnuMode() {
            return "gnu".equalsIgnoreCase(this.getValue());
        }

        public boolean isFailMode() {
            return "fail".equalsIgnoreCase(this.getValue());
        }

        public boolean isOmitMode() {
            return "omit".equalsIgnoreCase(this.getValue());
        }

        private final /* synthetic */ void this() {
            this.validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};
        }

        public TarLongFileMode() {
            this.this();
            this.setValue("warn");
        }
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public final String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private final OutputStream compress(OutputStream outputStream) throws IOException {
            String string = this.getValue();
            if (GZIP.equals(string)) {
                return new GZIPOutputStream(outputStream);
            }
            if (BZIP2.equals(string)) {
                outputStream.write(66);
                outputStream.write(90);
                return new CBZip2OutputStream(outputStream);
            }
            return outputStream;
        }

        public TarCompressionMethod() {
            this.setValue(NONE);
        }
    }
}

