/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExecuteWatchdog
implements TimeoutObserver {
    private Process process;
    private boolean watch;
    private Exception caught;
    private boolean killedProcess;
    private Watchdog watchdog;

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.watchdog.stop();
        this.watch = false;
        this.process = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void timeoutOccured(Watchdog watchdog) {
        try {
            try {
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (this.watch) {
                        this.killedProcess = true;
                        this.process.destroy();
                    }
                }
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.cleanUp();
            return;
        }
    }

    protected void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public void checkException() throws BuildException {
        if (this.caught != null) {
            throw new BuildException("Exception in ExecuteWatchdog.run: " + this.caught.getMessage(), this.caught);
        }
    }

    public boolean isWatching() {
        return this.watch;
    }

    public boolean killedProcess() {
        return this.killedProcess;
    }

    private final /* synthetic */ void this() {
        this.watch = false;
        this.caught = null;
        this.killedProcess = false;
    }

    public ExecuteWatchdog(long l) {
        this.this();
        this.watchdog = new Watchdog(l);
        this.watchdog.addTimeoutObserver(this);
    }

    public ExecuteWatchdog(int n) {
        this((long)n);
    }
}

