/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DirectoryScanner
implements FileScanner,
SelectorScanner,
ResourceFactory {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static Vector defaultExcludes = new Vector();
    private static final FileUtils FILE_UTILS;
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults;
    protected boolean isCaseSensitive;
    private boolean followSymlinks;
    protected boolean everythingIncluded;
    private Map fileListMap;
    private Set scannedDirs;

    protected static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl) {
        return SelectorUtils.matchPatternStart(string, string2, bl);
    }

    protected static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2);
    }

    protected static boolean matchPath(String string, String string2, boolean bl) {
        return SelectorUtils.matchPath(string, string2, bl);
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2);
    }

    protected static boolean match(String string, String string2, boolean bl) {
        return SelectorUtils.match(string, string2, bl);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String string) {
        if (defaultExcludes.indexOf(string) == -1) {
            defaultExcludes.add(string);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String string) {
        return defaultExcludes.remove(string);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        int n = 0;
        while (n < DEFAULTEXCLUDES.length) {
            defaultExcludes.add(DEFAULTEXCLUDES[n]);
            ++n;
        }
    }

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.includes[n] = string;
                ++n;
            }
        }
    }

    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.excludes[n] = string;
                ++n;
            }
        }
    }

    public void setSelectors(FileSelector[] fileSelectorArray) {
        this.selectors = fileSelectorArray;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.checkIncludePatterns();
        this.clearCaches();
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIncludePatterns() {
        block14: {
            block13: {
                var1_1 = new Hashtable<String, String>();
                var2_2 = 0;
                while (var2_2 < this.includes.length) {
                    var3_4 = SelectorUtils.rtrimWildcardTokens(this.includes[var2_2]);
                    var1_1.put((String)var3_4, this.includes[var2_2]);
                    ++var2_2;
                }
                if (!var1_1.containsKey("")) break block13;
                this.scandir(this.basedir, "", true);
                break block14;
            }
            var2_3 = var1_1.keys();
            var3_4 = null;
            try {
                var3_4 = this.basedir.getCanonicalFile();
                if (true) ** GOTO lbl50
            }
            catch (IOException var4_5) {
                throw new BuildException(var4_5);
            }
            do {
                var4_6 = (String)var2_3.nextElement();
                var5_7 = (String)var1_1.get(var4_6);
                var6_8 = new File(this.basedir, var4_6);
                if (var6_8.exists()) {
                    try {
                        var7_9 = var6_8.getCanonicalFile();
                        var8_11 = DirectoryScanner.FILE_UTILS.removeLeadingPath((File)var3_4, var7_9);
                        if ((!var8_11.equals(var4_6) || DirectoryScanner.ON_VMS) && (var6_8 = this.findFile(this.basedir, var4_6)) != null) {
                            var4_6 = DirectoryScanner.FILE_UTILS.removeLeadingPath(this.basedir, var6_8);
                        }
                    }
                    catch (IOException var7_10) {
                        throw new BuildException(var7_10);
                    }
                }
                if (!(var6_8 != null && var6_8.exists() || this.isCaseSensitive || !(var7_9 = this.findFileCaseInsensitive(this.basedir, var4_6)).exists())) {
                    var4_6 = DirectoryScanner.FILE_UTILS.removeLeadingPath(this.basedir, var7_9);
                    var6_8 = var7_9;
                }
                if (var6_8 == null || !var6_8.exists() || !this.followSymlinks && this.isSymlink(this.basedir, var4_6)) continue;
                if (var6_8.isDirectory()) {
                    if (this.isIncluded(var4_6) && var4_6.length() > 0) {
                        this.accountForIncludedDir(var4_6, var6_8, true);
                        continue;
                    }
                    if (var4_6.length() > 0 && var4_6.charAt(var4_6.length() - 1) != File.separatorChar) {
                        var4_6 = var4_6 + File.separatorChar;
                    }
                    this.scandir(var6_8, var4_6, true);
                    continue;
                }
                if (this.isCaseSensitive && var5_7.equals(var4_6)) {
                    this.accountForIncludedFile(var4_6, var6_8);
                    continue;
                }
                if (this.isCaseSensitive || !var5_7.equalsIgnoreCase(var4_6)) continue;
                this.accountForIncludedFile(var4_6, var6_8);
lbl50:
                // 7 sources

            } while (var2_3.hasMoreElements());
        }
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.couldHoldIncluded((String)objectArray[n])) {
                this.scandir(new File(this.basedir, (String)objectArray[n]), (String)objectArray[n] + File.separator, false);
            }
            ++n;
        }
        n = 0;
        while (n < objectArray2.length) {
            if (!this.couldHoldIncluded((String)objectArray2[n])) {
                this.scandir(new File(this.basedir, (String)objectArray2[n]), (String)objectArray2[n] + File.separator, false);
            }
            ++n;
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File file, String string, boolean bl) {
        Object object;
        if (file == null) {
            throw new BuildException("dir must not be null.");
        }
        if (!file.exists()) {
            throw new BuildException(file + " doesn't exists.");
        }
        if (!file.isDirectory()) {
            throw new BuildException(file + " is not a directory.");
        }
        if (bl && this.hasBeenScanned(string)) {
            return;
        }
        Object[] objectArray = file.list();
        if (objectArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object2;
                try {
                    if (FILE_UTILS.isSymbolicLink(file, objectArray[n])) {
                        object = string + (String)objectArray[n];
                        object2 = new File(file, (String)objectArray[n]);
                        if (((File)object2).isDirectory()) {
                            this.dirsExcluded.addElement(object);
                        } else {
                            this.filesExcluded.addElement(object);
                        }
                    } else {
                        vector.addElement(objectArray[n]);
                    }
                }
                catch (IOException iOException) {
                    object2 = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println((String)object2);
                    vector.addElement(objectArray[n]);
                }
                ++n;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            String string2 = string + objectArray[n];
            object = new File(file, (String)objectArray[n]);
            if (((File)object).isDirectory()) {
                if (this.isIncluded(string2)) {
                    this.accountForIncludedDir(string2, (File)object, bl);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (bl && this.couldHoldIncluded(string2)) {
                        this.scandir((File)object, string2 + File.separator, bl);
                    }
                }
                if (!bl) {
                    this.scandir((File)object, string2 + File.separator, bl);
                }
            } else if (((File)object).isFile()) {
                if (this.isIncluded(string2)) {
                    this.accountForIncludedFile(string2, (File)object);
                } else {
                    this.everythingIncluded = false;
                    this.filesNotIncluded.addElement(string2);
                }
            }
            ++n;
        }
    }

    private final void accountForIncludedFile(String string, File file) {
        if (!(this.filesIncluded.contains(string) || this.filesExcluded.contains(string) || this.filesDeselected.contains(string))) {
            if (!this.isExcluded(string)) {
                if (this.isSelected(string, file)) {
                    this.filesIncluded.addElement(string);
                } else {
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(string);
                }
            } else {
                this.everythingIncluded = false;
                this.filesExcluded.addElement(string);
            }
        }
    }

    private final void accountForIncludedDir(String string, File file, boolean bl) {
        if (!(this.dirsIncluded.contains(string) || this.dirsExcluded.contains(string) || this.dirsDeselected.contains(string))) {
            if (!this.isExcluded(string)) {
                if (this.isSelected(string, file)) {
                    this.dirsIncluded.addElement(string);
                    if (bl) {
                        this.scandir(file, string + File.separator, bl);
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsDeselected.addElement(string);
                    if (bl && this.couldHoldIncluded(string)) {
                        this.scandir(file, string + File.separator, bl);
                    }
                }
            } else {
                this.everythingIncluded = false;
                this.dirsExcluded.addElement(string);
                if (bl && this.couldHoldIncluded(string)) {
                    this.scandir(file, string + File.separator, bl);
                }
            }
        }
    }

    protected boolean isIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[n], string, this.isCaseSensitive) && this.isMorePowerfulThanExcludes(string, this.includes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean isMorePowerfulThanExcludes(String string, String string2) {
        String string3 = string + File.separator + "**";
        int n = 0;
        while (n < this.excludes.length) {
            if (this.excludes[n].equals(string3)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean isExcluded(String string) {
        int n = 0;
        while (n < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isSelected(String string, File file) {
        if (this.selectors != null) {
            int n = 0;
            while (n < this.selectors.length) {
                if (!this.selectors[n].isSelected(this.basedir, string, file)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] objectArray = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(objectArray);
        return objectArray;
    }

    public String[] getIncludedDirectories() {
        Object[] objectArray = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(objectArray);
        return objectArray;
    }

    public void addDefaultExcludes() {
        int n = 0;
        if (this.excludes != null) {
            n = this.excludes.length;
        }
        int n2 = n;
        String[] stringArray = new String[n2 + defaultExcludes.size()];
        if (n2 > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n2);
        }
        String[] stringArray2 = DirectoryScanner.getDefaultExcludes();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray[n3 + n2] = stringArray2[n3].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++n3;
        }
        this.excludes = stringArray;
    }

    public Resource getResource(String string) {
        File file = FILE_UTILS.resolveFile(this.basedir, string);
        return new Resource(string, file.exists(), file.lastModified(), file.isDirectory());
    }

    private final String[] list(File file) {
        String[] stringArray = (String[])this.fileListMap.get(file);
        if (stringArray == null && (stringArray = file.list()) != null) {
            this.fileListMap.put(file, stringArray);
        }
        return stringArray;
    }

    private final File findFileCaseInsensitive(File file, String string) {
        File file2 = this.findFileCaseInsensitive(file, SelectorUtils.tokenizePath(string));
        return file2 == null ? new File(file, string) : file2;
    }

    private final File findFileCaseInsensitive(File file, Vector vector) {
        if (vector.size() == 0) {
            return file;
        }
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = this.list(file);
        if (stringArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        String string = (String)vector.remove(0);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                file = new File(file, stringArray[n]);
                return this.findFileCaseInsensitive(file, vector);
            }
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                file = new File(file, stringArray[n]);
                return this.findFileCaseInsensitive(file, vector);
            }
            ++n;
        }
        return null;
    }

    private final File findFile(File file, String string) {
        return this.findFile(file, SelectorUtils.tokenizePath(string));
    }

    private final File findFile(File file, Vector vector) {
        if (vector.size() == 0) {
            return file;
        }
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = this.list(file);
        if (stringArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        String string = (String)vector.remove(0);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                file = new File(file, stringArray[n]);
                return this.findFile(file, vector);
            }
            ++n;
        }
        return null;
    }

    private final boolean isSymlink(File file, String string) {
        return this.isSymlink(file, SelectorUtils.tokenizePath(string));
    }

    private final boolean isSymlink(File file, Vector vector) {
        if (vector.size() > 0) {
            String string = (String)vector.remove(0);
            try {
                if (FILE_UTILS.isSymbolicLink(file, string)) {
                    return true;
                }
                file = new File(file, string);
                return this.isSymlink(file, vector);
            }
            catch (IOException iOException) {
                String string2 = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(string2);
                return false;
            }
        }
        return false;
    }

    private final boolean hasBeenScanned(String string) {
        return this.scannedDirs.add(string) ^ true;
    }

    private final void clearCaches() {
        this.fileListMap.clear();
        this.scannedDirs.clear();
    }

    private final /* synthetic */ void this() {
        this.selectors = null;
        this.haveSlowResults = false;
        this.isCaseSensitive = true;
        this.followSymlinks = true;
        this.everythingIncluded = true;
        this.fileListMap = new HashMap();
        this.scannedDirs = new HashSet();
    }

    public DirectoryScanner() {
        this.this();
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
        FILE_UTILS = FileUtils.newFileUtils();
    }
}

