/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.StringTokenizer;
import ymsg.network.PropertyConstants;

abstract class Util
implements PropertyConstants {
    public static boolean debugMode;
    private static final String[] ENTITIES_STR;
    private static final char[] ENTITIES_CHR;

    Util() {
    }

    static int loginTimeout(int def) {
        int loginTimeout = Integer.parseInt(System.getProperty("ymsg.network.loginTimeout", "" + def)) * 1000;
        if (loginTimeout <= 0) {
            loginTimeout = Integer.MAX_VALUE;
        }
        return loginTimeout;
    }

    static String directHost() {
        return System.getProperty("ymsg.network.directHost", "scs.msg.yahoo.com");
    }

    static int[] directPorts() {
        String s = System.getProperty("ymsg.network.directPorts");
        if (s == null) {
            return PropertyConstants.DIRECT_PORTS_DEFAULT;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] arr = new int[st.countTokens()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Integer.parseInt(st.nextToken());
        }
        return arr;
    }

    static int directPort() {
        return Util.directPorts()[0];
    }

    static String httpHost() {
        return System.getProperty("ymsg.network.httpHost", "http.pager.yahoo.com");
    }

    static String httpProxyAuth() {
        return System.getProperty("ymsg.network.httpProxyAuth");
    }

    static String fileTransferHost() {
        return System.getProperty("ymsg.network.fileTransferHost", "filetransfer.msg.yahoo.com");
    }

    static String httpProxyHost() {
        String host = System.getProperty("http.proxyHost");
        if (host == null) {
            host = System.getProperty("proxyHost");
        }
        return host;
    }

    static int httpProxyPort() {
        String port = System.getProperty("http.proxyPort");
        if (port == null) {
            port = System.getProperty("proxyPort");
        }
        if (port == null) {
            port = "8080";
        }
        return Integer.parseInt(port);
    }

    static String _base64(String table, char pad, byte[] buffer) {
        int i;
        int limit = buffer.length - buffer.length % 3;
        StringBuffer out = new StringBuffer();
        int[] buff = new int[buffer.length];
        for (i = 0; i < buffer.length; ++i) {
            buff[i] = buffer[i] & 0xFF;
        }
        for (i = 0; i < limit; i += 3) {
            out.append(table.charAt(buff[i] >> 2));
            out.append(table.charAt(buff[i] << 4 & 0x30 | buff[i + 1] >> 4));
            out.append(table.charAt(buff[i + 1] << 2 & 0x3C | buff[i + 2] >> 6));
            out.append(table.charAt(buff[i + 2] & 0x3F));
        }
        i = limit;
        switch (buff.length - i) {
            case 1: {
                out.append(table.charAt(buff[i] >> 2));
                out.append(table.charAt(buff[i] << 4 & 0x30));
                out.append(pad).append(pad);
                break;
            }
            case 2: {
                out.append(table.charAt(buff[i] >> 2));
                out.append(table.charAt(buff[i] << 4 & 0x30 | buff[i + 1] >> 4));
                out.append(table.charAt(buff[i + 1] << 2 & 0x3C));
                out.append(pad);
            }
        }
        return out.toString();
    }

    public static String base64(byte[] buffer) {
        return Util._base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", '=', buffer);
    }

    public static boolean isUtf8(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    static String entityDecode(String s) {
        StringBuffer result = new StringBuffer();
        int i1 = s.indexOf("&");
        while (i1 >= 0) {
            int i2 = s.indexOf(";");
            if (i2 >= 0 && i2 > i1 + 1) {
                result.append(s.substring(0, i1));
                String ent = s.substring(i1 + 1, i2).toLowerCase();
                int j = 0;
                for (j = 0; j < ENTITIES_STR.length; ++j) {
                    if (!ENTITIES_STR[j].equals(ent)) continue;
                    result.append(ENTITIES_CHR[j]);
                    break;
                }
                if (j >= ENTITIES_STR.length) {
                    result.append('&');
                    result.append(ent);
                    result.append(';');
                }
                s = s.substring(i2 + 1);
            } else {
                result.append(s.substring(0, i2 + 1));
                s = s.substring(i2 + 1);
            }
            i1 = s.indexOf("&");
        }
        result.append(s);
        return result.toString();
    }

    static synchronized void dump(byte[] array) {
        String c = "";
        for (int i = 0; i < array.length; ++i) {
            String s = "0" + Integer.toHexString(array[i]);
            System.out.print(s.substring(s.length() - 2) + " ");
            c = array[i] >= 32 && array[i] <= 126 ? c + (char)array[i] : c + ".";
            if (i + 1 == array.length) {
                while (i % 20 != 19) {
                    System.out.print("   ");
                    ++i;
                }
            }
            if ((i + 1) % 20 != 0 && i + 1 < array.length) continue;
            System.out.print(" " + c + "\n");
            c = "";
        }
    }

    static void dump(byte[] array, String s) {
        System.out.println(s + "\n01-02-03-04-05-06-07-08-09-10-11-12-13-14-15-16-17-18-19-20");
        Util.dump(array);
    }

    static int[] yahoo64Decode(String s) {
        if (s.length() % 4 != 0) {
            throw new IllegalArgumentException("Source string incomplete");
        }
        int len = s.length() / 4;
        if (s.endsWith("--")) {
            len -= 2;
        } else if (s.endsWith("-")) {
            --len;
        }
        int[] buffer = new int[len];
        int[] c = new int[4];
        int bpos = 0;
        try {
            for (int i = 0; i < s.length(); i += 4) {
                int j = 0;
                while (i < c.length) {
                    c[j] = Util._c2b(s.charAt(i + j));
                    ++j;
                }
                buffer[bpos + 0] = (c[0] << 2) + (c[1] >> 4) & 0xFF;
                buffer[bpos + 1] = (c[1] & 0xF) << 4 + (c[2] >> 2) & 0xFF;
                buffer[bpos + 2] = (c[2] & 3) << 6 + c[3] & 0xFF;
                bpos += 3;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return buffer;
    }

    private static int _c2b(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c - 97 + 26;
        }
        if (c >= 48 && c <= 57) {
            return c - 48 + 52;
        }
        if (c == 46) {
            return 62;
        }
        if (c == 95) {
            return 63;
        }
        return 0;
    }

    static {
        String p = System.getProperty("ymsg.debug", "false");
        debugMode = p.equalsIgnoreCase("true");
        ENTITIES_STR = new String[]{"apos", "quot", "amp", "lt", "gt", "nbsp", "curren", "cent", "pound", "yen", "copy"};
        ENTITIES_CHR = new char[]{'\'', '\"', '&', '<', '>', ' ', '\u00a4', '\u00a2', '\u00a3', '\u00a5', '\u00a9'};
    }
}

