/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.StringBlock;

public final class BinaryTools {
    public static final long UINT_MAX = 0xFFFFFFFFL;
    public static final int USHORT_MAX = 65535;
    public static final short UBYTE_MAX = 255;

    private BinaryTools() {
    }

    public static long getLong(ByteBlock data, int pos) throws ArrayIndexOutOfBoundsException {
        int i;
        long num = 0L;
        int end = i + 8;
        for (i = pos; i < end; ++i) {
            int offset = (end - i - 1) * 8;
            num |= ((long)data.get(i) & 0xFFL) << offset;
        }
        return num;
    }

    public static long getUInt(ByteBlock data, int pos) {
        if (data.getLength() - pos < 4) {
            return -1L;
        }
        return ((long)data.get(pos) & 0xFFL) << 24 | ((long)data.get(pos + 1) & 0xFFL) << 16 | ((long)data.get(pos + 2) & 0xFFL) << 8 | (long)data.get(pos + 3) & 0xFFL;
    }

    public static int getUShort(ByteBlock data, int pos) {
        if (data.getLength() - pos < 2) {
            return -1;
        }
        return (data.get(pos) & 0xFF) << 8 | data.get(pos + 1) & 0xFF;
    }

    public static short getUByte(ByteBlock data, int pos) {
        if (data.getLength() - pos < 1) {
            return -1;
        }
        return (short)(data.get(pos) & 0xFF);
    }

    public static Inet4Address getIPFromBytes(ByteBlock data, int pos) {
        if (data.getLength() - pos < 4) {
            return null;
        }
        byte[] address = data.subBlock(pos, 4).toByteArray();
        Inet4Address ip = null;
        try {
            ip = (Inet4Address)Inet4Address.getByAddress(address);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return ip;
    }

    public static String describeData(ByteBlock data) {
        if (data == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.getLength(); ++i) {
            String str;
            byte b = data.get(i);
            if (i != 0) {
                buffer.append(' ');
            }
            if ((str = Integer.toHexString(b & 0xFF)).length() == 1) {
                buffer.append('0');
            }
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static void writeLong(OutputStream out, long number) throws IOException {
        out.write(BinaryTools.getLong(number));
    }

    public static void writeUInt(OutputStream out, long number) throws IOException {
        out.write(BinaryTools.getUInt(number));
    }

    public static void writeUShort(OutputStream out, int number) throws IOException {
        out.write(BinaryTools.getUShort(number));
    }

    public static void writeUByte(OutputStream out, int number) throws IOException {
        out.write(BinaryTools.getUByte(number));
    }

    public static byte[] getLong(long number) {
        byte[] data = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = (7 - i) * 8;
            data[i] = (byte)(number >> offset & 0xFFL);
        }
        return data;
    }

    public static byte[] getUInt(long number) {
        return new byte[]{(byte)(number >> 24 & 0xFFL), (byte)(number >> 16 & 0xFFL), (byte)(number >> 8 & 0xFFL), (byte)(number & 0xFFL)};
    }

    public static byte[] getUShort(int number) {
        return new byte[]{(byte)(number >> 8 & 0xFF), (byte)(number & 0xFF)};
    }

    public static byte[] getUByte(int number) {
        return new byte[]{(byte)(number & 0xFF)};
    }

    public static byte[] getAsciiBytes(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException impossible) {
            return null;
        }
    }

    public static String getAsciiString(ByteBlock data) {
        try {
            return ByteBlock.createString(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException impossible) {
            return null;
        }
    }

    public static StringBlock getNullPadded(ByteBlock block) {
        int firstNull;
        for (firstNull = 0; firstNull < block.getLength() && block.get(firstNull) != 0; ++firstNull) {
        }
        ByteBlock strBlock = block.subBlock(0, firstNull);
        return new StringBlock(BinaryTools.getAsciiString(strBlock), strBlock.getLength());
    }

    public static void writeNullPadded(OutputStream out, ByteBlock block, int len) throws IOException {
        if (block.getLength() <= len) {
            block.write(out);
            out.write(new byte[len - block.getLength()]);
        } else {
            block.subBlock(0, len).write(out);
        }
    }
}

