/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.guido;

import com.voxeo.guido.GuidoException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class Guido {
    static SecureRandom _secRnd = new SecureRandom();
    static long _lCounter = 0L;
    static int _nDefaultHost;
    static final char[] HEXTAB;
    public static final int STRINGSIZE = 32;
    static String HASH_NAME;
    long m_lUID;
    int m_nHost;
    int m_nAuth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getUIDSeed(byte[] buf) {
        SecureRandom secureRandom = _secRnd;
        synchronized (secureRandom) {
            _secRnd.nextBytes(buf);
            return _lCounter++;
        }
    }

    static String bytesToHex(byte[] buf, int nOfs, int nCount) {
        StringBuffer sb = new StringBuffer();
        sb.setLength(nCount << 1);
        int nPos = 0;
        for (int nI = 0; nI < nCount; ++nI) {
            sb.setCharAt(nPos++, HEXTAB[buf[nI + nOfs] >> 4 & 0xF]);
            sb.setCharAt(nPos++, HEXTAB[buf[nI + nOfs] & 0xF]);
        }
        return sb.toString();
    }

    static byte[] hexToBytes(String sHex) {
        int nCount = sHex.length();
        if (1 == (nCount & 1)) {
            return null;
        }
        byte[] result = new byte[nCount >>= 1];
        int nI = 0;
        int nPos = 0;
        while (nPos < nCount) {
            int bReg = 0;
            for (int nJ = 0; nJ < 2; ++nJ) {
                char cNb;
                bReg = (byte)(bReg << 4);
                if ('a' <= (cNb = Character.toLowerCase(sHex.charAt(nI++))) && 'f' >= cNb) {
                    bReg = (byte)(bReg | (byte)(cNb - 97) + 10);
                    continue;
                }
                if ('0' <= cNb && '9' >= cNb) {
                    bReg = (byte)(bReg | (byte)(cNb - 48));
                    continue;
                }
                return null;
            }
            result[nPos++] = bReg;
        }
        return result;
    }

    static void longToBytes(long lValue, byte[] buf, int nOfs) {
        buf[nOfs] = (byte)(lValue >>> 56);
        buf[nOfs + 1] = (byte)(lValue >>> 48 & 0xFFL);
        buf[nOfs + 2] = (byte)(lValue >>> 40 & 0xFFL);
        buf[nOfs + 3] = (byte)(lValue >>> 32 & 0xFFL);
        buf[nOfs + 4] = (byte)(lValue >>> 24 & 0xFFL);
        buf[nOfs + 5] = (byte)(lValue >>> 16 & 0xFFL);
        buf[nOfs + 6] = (byte)(lValue >>> 8 & 0xFFL);
        buf[nOfs + 7] = (byte)(lValue & 0xFFL);
    }

    static void intToBytes(int nValue, byte[] buf, int nOfs) {
        buf[nOfs] = (byte)(nValue >>> 24 & 0xFF);
        buf[nOfs + 1] = (byte)(nValue >>> 16 & 0xFF);
        buf[nOfs + 2] = (byte)(nValue >>> 8 & 0xFF);
        buf[nOfs + 3] = (byte)(nValue & 0xFF);
    }

    static long bytesToLong(byte[] buf, int nOfs) {
        return (long)buf[nOfs] << 56 | ((long)buf[nOfs + 1] & 0xFFL) << 48 | ((long)buf[nOfs + 2] & 0xFFL) << 40 | ((long)buf[nOfs + 3] & 0xFFL) << 32 | ((long)buf[nOfs + 4] & 0xFFL) << 24 | ((long)buf[nOfs + 5] & 0xFFL) << 16 | ((long)buf[nOfs + 6] & 0xFFL) << 8 | (long)buf[nOfs + 7] & 0xFFL;
    }

    static int bytesToInt(byte[] buf, int nOfs) {
        return (buf[nOfs] & 0xFF) << 24 | (buf[nOfs + 1] & 0xFF) << 16 | (buf[nOfs + 2] & 0xFF) << 8 | buf[nOfs + 3] & 0xFF;
    }

    int calcAuth(byte[] secret) throws GuidoException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_NAME);
            if (null != secret) {
                md.update(secret);
            }
            byte[] tmp = new byte[8];
            Guido.longToBytes(this.m_lUID, tmp, 0);
            md.update(tmp);
            tmp = new byte[4];
            Guido.intToBytes(this.m_nHost, tmp, 0);
            md.update(tmp);
            byte[] hash = md.digest();
            int nResult = 0;
            for (int nI = 0; nI < hash.length; nI += 4) {
                nResult ^= Guido.bytesToInt(hash, nI);
            }
            return nResult;
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuidoException("SHA-1 not available");
        }
    }

    public Guido(byte[] secret) throws GuidoException {
        this.create(null, secret);
    }

    public Guido(InetAddress addr, byte[] secret) throws GuidoException {
        this.create(addr, secret);
    }

    void create(InetAddress addr, byte[] secret) throws GuidoException {
        byte[] rnd = new byte[16];
        byte[] cb = new byte[8];
        byte[] tm = new byte[8];
        Guido.longToBytes(System.currentTimeMillis(), tm, 0);
        Guido.longToBytes(Guido.getUIDSeed(rnd), cb, 0);
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_NAME);
            md.update(rnd);
            md.update(cb);
            byte[] hash = md.digest();
            int nUIDHi = Guido.bytesToInt(hash, 0) ^ Guido.bytesToInt(hash, 4);
            int nUIDLo = Guido.bytesToInt(hash, 8) ^ Guido.bytesToInt(hash, 12) ^ Guido.bytesToInt(hash, 16);
            this.m_lUID = (long)nUIDHi << 32 | (long)nUIDLo & 0xFFFFFFFFL;
            this.m_nHost = null == addr ? _nDefaultHost : Guido.bytesToInt(addr.getAddress(), 0);
            this.m_nHost ^= nUIDHi ^ nUIDLo;
            this.m_nAuth = this.calcAuth(secret);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuidoException("SHA-1 not available");
        }
    }

    public Guido(String sBuf, boolean blAuthenticate, byte[] secret) throws GuidoException {
        if (32 != sBuf.length()) {
            throw new GuidoException("invalid size");
        }
        byte[] buf = Guido.hexToBytes(sBuf);
        if (null == buf) {
            throw new GuidoException("hex conversion failed");
        }
        this.m_lUID = Guido.bytesToLong(buf, 0);
        this.m_nHost = Guido.bytesToInt(buf, 8);
        this.m_nAuth = Guido.bytesToInt(buf, 12);
        if (blAuthenticate && this.m_nAuth != this.calcAuth(secret)) {
            throw new GuidoException("authentication failed");
        }
    }

    public long GetUID() {
        return this.m_lUID;
    }

    public int GetHost() {
        return this.m_nHost;
    }

    public int GetAuth() {
        return this.m_nAuth;
    }

    public String decodeHost() {
        int nHost = this.m_nHost;
        nHost ^= (int)(this.m_lUID & 0xFFFFFFFFFFFFFFFFL);
        nHost ^= (int)(this.m_lUID >> 32);
        String sResult = "";
        for (int nI = 0; nI < 4; ++nI) {
            if (0 < nI) {
                sResult = "." + sResult;
            }
            sResult = (nHost & 0xFF) + sResult;
            nHost >>= 8;
        }
        return sResult;
    }

    public InetAddress decodeHostToAddress() throws GuidoException {
        try {
            return InetAddress.getByName(this.decodeHost());
        }
        catch (UnknownHostException uhe) {
            throw new GuidoException("address conversion failed");
        }
    }

    public String toString() {
        byte[] buf = new byte[16];
        Guido.longToBytes(this.m_lUID, buf, 0);
        Guido.intToBytes(this.m_nHost, buf, 8);
        Guido.intToBytes(this.m_nAuth, buf, 12);
        return Guido.bytesToHex(buf, 0, buf.length);
    }

    static {
        try {
            byte[] addrBin = InetAddress.getLocalHost().getAddress();
            _nDefaultHost = Guido.bytesToInt(addrBin, 0);
        }
        catch (Exception e) {
            System.out.println("Guido: cannot get host address");
        }
        HEXTAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HASH_NAME = "SHA";
    }
}

