/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import java.util.Locale;
import javax.sip.header.ContentLanguageHeader;

public class ContentLanguage
extends SIPHeader
implements ContentLanguageHeader {
    private static final long serialVersionUID = -5195728427134181070L;
    protected Locale locale;

    public ContentLanguage() {
        super("Content-Language");
    }

    public ContentLanguage(String string) {
        super("Content-Language");
        this.setLanguageTag(string);
    }

    public String encodeBody() {
        return this.getLanguageTag();
    }

    public String getLanguageTag() {
        if ("".equals(this.locale.getCountry())) {
            return this.locale.getLanguage();
        }
        return this.locale.getLanguage() + '-' + this.locale.getCountry();
    }

    public void setLanguageTag(String string) {
        int n = string.indexOf(45);
        this.locale = n >= 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string);
    }

    public Locale getContentLanguage() {
        return this.locale;
    }

    public void setContentLanguage(Locale locale) {
        this.locale = locale;
    }

    public Object clone() {
        ContentLanguage contentLanguage = (ContentLanguage)super.clone();
        if (this.locale != null) {
            contentLanguage.locale = (Locale)this.locale.clone();
        }
        return contentLanguage;
    }
}

