/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apache.ant.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;

public class Unpack200Task
extends Unpack {
    private SortedMap<String, String> propMap;
    private Pack200.Unpacker unpkr = Pack200.newUnpacker();

    public Unpack200Task() {
        this.propMap = this.unpkr.properties();
    }

    protected String getDefaultExtension() {
        return ".jar";
    }

    public void setVerbose(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.verbose", value);
    }

    private FileType getMagic(File in) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(in));
        int i = is.readInt();
        is.close();
        if ((i & 0xFFFFFF00) == 529205248) {
            return FileType.gzip;
        }
        if (i == -889270259) {
            return FileType.pack200;
        }
        if (i == 1347093252) {
            return FileType.zip;
        }
        return FileType.unknown;
    }

    protected void extract() {
        System.out.println("Unpacking with Unpack200");
        System.out.println("Source File :" + this.source);
        System.out.println("Dest.  File :" + this.dest);
        try {
            FileInputStream fis = new FileInputStream(this.source);
            BufferedInputStream is = FileType.gzip == this.getMagic(this.source) ? new BufferedInputStream(new GZIPInputStream(fis)) : new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(this.dest);
            JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(fos));
            this.unpkr.unpack((InputStream)is, jout);
            ((InputStream)is).close();
            jout.close();
        }
        catch (IOException ioe) {
            throw new BuildException("Error in unpack200");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        unknown,
        gzip,
        pack200,
        zip;

    }
}

